/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.compute.JobExecutorType;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.StreamerReceiverSerializer;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.partition.HashPartition;
import org.apache.ignite.table.ReceiverExecutionOptions;
import org.apache.ignite.table.partition.Partition;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientStreamerWithReceiverBatchSendRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTablesInternal tables, boolean enableExecutionOptions, HybridTimestampTracker tsTracker) {
        SecurityContext securityContext = SecurityContextHolder.getOrThrow();
        int tableId = in.unpackInt();
        int partition = in.unpackInt();
        List deploymentUnits = in.unpackDeploymentUnits();
        boolean returnResults = in.unpackBoolean();
        int payloadElementCount = in.unpackInt();
        int payloadSize = in.unpackBinaryHeader();
        byte[] payloadArr = new byte[payloadSize + 4];
        ByteBuffer payloadBuf = ByteBuffer.wrap(payloadArr).order(ByteOrder.LITTLE_ENDIAN);
        payloadBuf.putInt(payloadElementCount);
        in.readPayload(payloadBuf);
        ReceiverExecutionOptions options = enableExecutionOptions ? ReceiverExecutionOptions.builder().priority(in.unpackInt()).maxRetries(in.unpackInt()).executorType(JobExecutorType.fromOrdinal((int)in.unpackInt())).build() : ReceiverExecutionOptions.DEFAULT;
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ((CompletableFuture)((CompletableFuture)table.partitionManager().primaryReplicaAsync((Partition)new HashPartition(partition)).thenApply(ClusterNodeImpl::fromPublicClusterNode)).thenCompose(node -> table.internalTable().streamerReceiverRunner().runReceiverAsync(payloadArr, (InternalClusterNode)node, deploymentUnits, options, securityContext))).thenApply(res -> {
            byte[] resBytes = (byte[])res.get1();
            Long observableTs = (Long)res.get2();
            assert (observableTs != null) : "Observable timestamp should not be null";
            assert (observableTs != 0L) : "Observable timestamp should not be NULL_HYBRID_TIMESTAMP";
            tsTracker.update(observableTs.longValue());
            return out -> StreamerReceiverSerializer.serializeReceiverResultsForClient((ClientMessagePacker)out, (byte[])((byte[])(returnResults ? resBytes : null)));
        }));
    }
}

