/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.table.QualifiedName;
import org.jetbrains.annotations.Nullable;

public class ClientMessagePacker
implements AutoCloseable {
    private final ByteBuf buf;
    private boolean closed;

    public ClientMessagePacker(ByteBuf buf) {
        this.buf = buf.writerIndex(4);
    }

    public ByteBuf getBuffer() {
        this.buf.setInt(0, this.buf.writerIndex() - 4);
        return this.buf;
    }

    public void packNil() {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-64);
    }

    public void packBoolean(boolean b) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(b ? -61 : -62);
    }

    public void packByte(byte b) {
        assert (!this.closed) : "Packer is closed";
        if (b < -32) {
            this.buf.writeByte(-48);
        }
        this.buf.writeByte((int)b);
    }

    public void packShort(short v) {
        assert (!this.closed) : "Packer is closed";
        if (v < -32) {
            if (v < -128) {
                this.buf.writeByte(-47);
                this.buf.writeShort((int)v);
            } else {
                this.buf.writeByte(-48);
                this.buf.writeByte((int)v);
            }
        } else if (v < 128) {
            this.buf.writeByte((int)v);
        } else if (v < 256) {
            this.buf.writeByte(-52);
            this.buf.writeByte((int)v);
        } else {
            this.buf.writeByte(-51);
            this.buf.writeShort((int)v);
        }
    }

    public void packInt(int i) {
        assert (!this.closed) : "Packer is closed";
        if (i < -32) {
            if (i < Short.MIN_VALUE) {
                this.buf.writeByte(-46);
                this.buf.writeInt(i);
            } else if (i < -128) {
                this.buf.writeByte(-47);
                this.buf.writeShort(i);
            } else {
                this.buf.writeByte(-48);
                this.buf.writeByte(i);
            }
        } else if (i < 128) {
            this.buf.writeByte(i);
        } else if (i < 256) {
            this.buf.writeByte(-52);
            this.buf.writeByte(i);
        } else if (i < 65536) {
            this.buf.writeByte(-51);
            this.buf.writeShort(i);
        } else {
            this.buf.writeByte(-50);
            this.buf.writeInt(i);
        }
    }

    public void packIntNullable(Integer i) {
        if (i == null) {
            this.packNil();
        } else {
            this.packInt(i);
        }
    }

    public int reserveLong() {
        this.buf.writeByte(-45);
        int index = this.buf.writerIndex();
        this.buf.writeLong(0L);
        return index;
    }

    public void setLong(int index, long v) {
        this.buf.setLong(index, v);
    }

    public int reserveInt() {
        this.buf.writeByte(-46);
        int index = this.buf.writerIndex();
        this.buf.writeInt(0);
        return index;
    }

    public void setInt(int index, int v) {
        this.buf.setInt(index, v);
    }

    public void packLong(long v) {
        assert (!this.closed) : "Packer is closed";
        if (v < -32L) {
            if (v < -32768L) {
                if (v < Integer.MIN_VALUE) {
                    this.buf.writeByte(-45);
                    this.buf.writeLong(v);
                } else {
                    this.buf.writeByte(-46);
                    this.buf.writeInt((int)v);
                }
            } else if (v < -128L) {
                this.buf.writeByte(-47);
                this.buf.writeShort((int)((short)v));
            } else {
                this.buf.writeByte(-48);
                this.buf.writeByte((int)((byte)v));
            }
        } else if (v < 128L) {
            this.buf.writeByte((int)((byte)v));
        } else if (v < 65536L) {
            if (v < 256L) {
                this.buf.writeByte(-52);
                this.buf.writeByte((int)((byte)v));
            } else {
                this.buf.writeByte(-51);
                this.buf.writeShort((int)((short)v));
            }
        } else if (v < 0x100000000L) {
            this.buf.writeByte(-50);
            this.buf.writeInt((int)v);
        } else {
            this.buf.writeByte(-49);
            this.buf.writeLong(v);
        }
    }

    public void packLongNullable(@Nullable Long v) {
        if (v == null) {
            this.packNil();
        } else {
            this.packLong(v);
        }
    }

    public void packByteNullable(@Nullable Byte v) {
        if (v == null) {
            this.packNil();
        } else {
            this.packByte(v);
        }
    }

    public void packStringNullable(@Nullable String v) {
        if (v == null) {
            this.packNil();
        } else {
            this.packString(v);
        }
    }

    public void packFloat(float v) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-54);
        this.buf.writeFloat(v);
    }

    public void packDouble(double v) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-53);
        this.buf.writeDouble(v);
    }

    public void packString(@Nullable String s) {
        assert (!this.closed) : "Packer is closed";
        if (s == null) {
            this.packNil();
            return;
        }
        int maxBytes = ByteBufUtil.utf8MaxBytes((CharSequence)s);
        int headerSize = this.getStringHeaderSize(maxBytes);
        int headerPos = this.buf.writerIndex();
        int index = headerPos + headerSize;
        if (index > this.buf.capacity()) {
            this.buf.capacity(this.buf.capacity() * 2);
        }
        this.buf.writerIndex(index);
        int bytesWritten = ByteBufUtil.writeUtf8((ByteBuf)this.buf, (CharSequence)s);
        int endPos = this.buf.writerIndex();
        this.buf.writerIndex(headerPos);
        if (headerSize == 1) {
            this.buf.writeByte((int)((byte)(0xFFFFFFA0 | bytesWritten)));
        } else if (headerSize == 2) {
            this.buf.writeByte(-39);
            this.buf.writeByte(bytesWritten);
        } else if (headerSize == 3) {
            this.buf.writeByte(-38);
            this.buf.writeShort(bytesWritten);
        } else {
            assert (headerSize == 5) : "headerSize == 5";
            this.buf.writeByte(-37);
            this.buf.writeInt(bytesWritten);
        }
        this.buf.writerIndex(endPos);
    }

    public void packExtensionTypeHeader(byte extType, int payloadLen) {
        assert (!this.closed) : "Packer is closed";
        if (payloadLen < 256) {
            if (payloadLen > 0 && (payloadLen & payloadLen - 1) == 0) {
                if (payloadLen == 1) {
                    this.buf.writeByte(-44);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 2) {
                    this.buf.writeByte(-43);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 4) {
                    this.buf.writeByte(-42);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 8) {
                    this.buf.writeByte(-41);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 16) {
                    this.buf.writeByte(-40);
                    this.buf.writeByte((int)extType);
                } else {
                    this.buf.writeByte(-57);
                    this.buf.writeByte(payloadLen);
                    this.buf.writeByte((int)extType);
                }
            } else {
                this.buf.writeByte(-57);
                this.buf.writeByte(payloadLen);
                this.buf.writeByte((int)extType);
            }
        } else if (payloadLen < 65536) {
            this.buf.writeByte(-56);
            this.buf.writeShort(payloadLen);
            this.buf.writeByte((int)extType);
        } else {
            this.buf.writeByte(-55);
            this.buf.writeInt(payloadLen);
            this.buf.writeByte((int)extType);
        }
    }

    public void packBinaryHeader(int len) {
        assert (!this.closed) : "Packer is closed";
        if (len < 256) {
            this.buf.writeByte(-60);
            this.buf.writeByte(len);
        } else if (len < 65536) {
            this.buf.writeByte(-59);
            this.buf.writeShort(len);
        } else {
            this.buf.writeByte(-58);
            this.buf.writeInt(len);
        }
    }

    public void packRawStringHeader(int len) {
        assert (!this.closed) : "Packer is closed";
        if (len < 32) {
            this.buf.writeByte((int)((byte)(0xFFFFFFA0 | len)));
        } else if (len < 256) {
            this.buf.writeByte(-39);
            this.buf.writeByte(len);
        } else if (len < 65536) {
            this.buf.writeByte(-38);
            this.buf.writeShort(len);
        } else {
            this.buf.writeByte(-37);
            this.buf.writeInt(len);
        }
    }

    public void writePayload(byte[] src) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeBytes(src);
    }

    public void writePayload(ByteBuffer src) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeBytes(src);
    }

    public void writePayload(byte[] src, int off, int len) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeBytes(src, off, len);
    }

    void writeIntRawLittleEndian(int payload) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeIntLE(payload);
    }

    public void packUuid(UUID val) {
        assert (!this.closed) : "Packer is closed";
        this.packExtensionTypeHeader((byte)3, 16);
        this.buf.writeLongLE(val.getMostSignificantBits());
        this.buf.writeLongLE(val.getLeastSignificantBits());
    }

    public void packUuidNullable(@Nullable UUID val) {
        if (val == null) {
            this.packNil();
        } else {
            this.packUuid(val);
        }
    }

    public void packBitSet(BitSet val) {
        assert (!this.closed) : "Packer is closed";
        byte[] data = val.toByteArray();
        this.packExtensionTypeHeader((byte)8, data.length);
        this.buf.writeBytes(data);
    }

    public void packBitSetNullable(@Nullable BitSet val) {
        if (val == null) {
            this.packNil();
        } else {
            this.packBitSet(val);
        }
    }

    public void packIntArray(int[] arr) {
        assert (!this.closed) : "Packer is closed";
        if (arr == null) {
            this.packNil();
            return;
        }
        this.packInt(arr.length);
        for (int i : arr) {
            this.packInt(i);
        }
    }

    public void packLongArray(long[] arr) {
        assert (!this.closed) : "Packer is closed";
        if (arr == null) {
            this.packNil();
            return;
        }
        this.packInt(arr.length);
        for (long i : arr) {
            this.packLong(i);
        }
    }

    public void packObjectArrayAsBinaryTuple(Object @Nullable [] vals) {
        assert (!this.closed) : "Packer is closed";
        if (vals == null) {
            this.packNil();
            return;
        }
        this.packInt(vals.length);
        if (vals.length == 0) {
            return;
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(vals.length * 3);
        for (Object arg : vals) {
            ClientBinaryTupleUtils.appendObject(builder, arg);
        }
        this.packBinaryTuple(builder);
    }

    public void packBatchedArgumentsAsBinaryTupleArray(BatchedArguments batchedArguments) {
        assert (!this.closed) : "Packer is closed";
        if (batchedArguments == null || batchedArguments.isEmpty()) {
            this.packNil();
            return;
        }
        int rowLen = batchedArguments.get(0).size();
        this.packInt(rowLen);
        this.packInt(batchedArguments.size());
        this.packBoolean(false);
        for (List values : batchedArguments) {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(rowLen * 3);
            for (Object value : values) {
                ClientBinaryTupleUtils.appendObject(builder, value);
            }
            this.packBinaryTuple(builder);
        }
    }

    public <T> void packObjectAsBinaryTuple(@Nullable T val) {
        assert (!this.closed) : "Packer is closed";
        if (val == null) {
            this.packNil();
            return;
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(3, 3, false);
        ClientBinaryTupleUtils.appendObject(builder, val);
        this.packBinaryTuple(builder);
    }

    public void packBinaryTuple(BinaryTupleBuilder builder, BitSet noValueSet) {
        this.packBinaryTuple(builder.build(), noValueSet);
    }

    public void packBinaryTuple(ByteBuffer buffer, BitSet noValueSet) {
        this.packBitSet(noValueSet);
        this.packBinaryHeader(buffer.limit() - buffer.position());
        this.writePayload(buffer);
    }

    public void packBinaryTuple(byte[] buffer, BitSet noValueSet) {
        this.packBitSet(noValueSet);
        this.packBinaryHeader(buffer.length);
        this.writePayload(buffer);
    }

    public void packBinaryTuple(BinaryTupleParser binaryTupleParser) {
        ByteBuffer buf = binaryTupleParser.byteBuffer();
        int len = buf.limit() - buf.position();
        this.packBinaryHeader(len);
        this.writePayload(buf);
    }

    public void packBinaryTuple(BinaryTupleBuilder builder) {
        ByteBuffer buf = builder.build();
        this.packByteBuffer(buf);
    }

    public void packBinary(byte[] buf) {
        assert (!this.closed) : "Packer is closed";
        this.packBinaryHeader(buf.length);
        this.writePayload(buf);
    }

    public void packByteBuffer(ByteBuffer buf) {
        assert (!this.closed) : "Packer is closed";
        this.packBinaryHeader(buf.limit() - buf.position());
        this.writePayload(buf);
    }

    public void packInstant(@Nullable Instant instant) {
        if (instant == null) {
            this.packNil();
        } else {
            this.packLong(instant.getEpochSecond());
            this.packInt(instant.getNano());
        }
    }

    public void packDeploymentUnits(List<DeploymentUnit> units) {
        this.packInt(units.size());
        for (DeploymentUnit unit : units) {
            this.packString(unit.name());
            this.packString(unit.version().render());
        }
    }

    public void packQualifiedName(QualifiedName name) {
        this.packString(name.schemaName());
        this.packString(name.objectName());
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    private int getStringHeaderSize(int len) {
        assert (!this.closed) : "Packer is closed";
        if (len < 32) {
            return 1;
        }
        if (len < 256) {
            return 2;
        }
        if (len < 65536) {
            return 3;
        }
        return 5;
    }
}

