/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.role.repl;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRevokeCallInput;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRoleCall;
import picocli.CommandLine;

@CommandLine.Command(name="assign", description={"Assign role to user"})
public class UserRoleAssignReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--to"}, description={"To username"}, required=true, split=",")
    private List<String> username;
    @CommandLine.Option(names={"--role", "-r"}, description={"Role name"}, required=true, split=",")
    private List<String> roleName;
    @Inject
    private AssignRoleCall assignRoleCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.assignRoleCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot assign role")).print());
    }

    private AssignRevokeCallInput input(String clusterUrl) {
        return AssignRevokeCallInput.builder().clusterUrl(clusterUrl).roleNames(this.roleName).usernames(this.username).build();
    }
}

