/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.restore;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.snapshot.SnapshotRestoreCall;
import org.gridgain.internal.cli.call.snapshot.SnapshotRestoreCallInput;
import org.gridgain.internal.cli.commands.snapshot.restore.SnapshotRestoreMixin;
import picocli.CommandLine;

@CommandLine.Command(name="restore", description={"Restores a snapshot"})
public class SnapshotRestoreReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private SnapshotRestoreMixin options;
    @Inject
    private SnapshotRestoreCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot restore snapshot")).print());
    }

    private SnapshotRestoreCallInput buildCallInput(String clusterUrl) {
        return SnapshotRestoreCallInput.builder().clusterUrl(clusterUrl).snapshotId(this.options.snapshotId()).tableNames(this.options.tableNames()).structureNames(this.options.structureNames()).force(this.options.force()).source(this.options.source()).decryptionProvider(this.options.decryptionProvider()).build();
    }
}

