/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.role.DeleteRoleCallInput;
import org.gridgain.internal.cli.call.rbac.role.DeleteRoleReplCall;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete role if exists"})
public class RoleDeleteReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(description={"Role name"})
    private String roleName;
    @CommandLine.Option(names={"-r", "--with-revoke"}, description={"Revoke connected roles and users."})
    private boolean withRevoke;
    @Inject
    private DeleteRoleReplCall deleteRoleCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.deleteRoleCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot delete role")).print());
    }

    private DeleteRoleCallInput input(String clusterUrl) {
        return DeleteRoleCallInput.builder().clusterUrl(clusterUrl).roleName(this.roleName).withRevoke(this.withRevoke).build();
    }
}

