/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.privilege;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.assignments.GrantRevokePrivilegeCallInput;
import org.gridgain.internal.cli.call.rbac.assignments.RevokePrivilegeCall;
import org.gridgain.internal.cli.call.rbac.privilege.Action;
import org.gridgain.internal.cli.core.converters.ActionConverter;
import picocli.CommandLine;

@CommandLine.Command(name="revoke", description={"Revoke privilege from role"})
public class RolePrivilegeRevokeCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--from"}, description={"From role"}, required=true, split=",")
    private List<String> roleName;
    @CommandLine.Option(names={"--action"}, description={"Action"}, required=true, converter={ActionConverter.class}, split=",")
    private List<Action> action;
    @CommandLine.Option(names={"--on"}, description={"Object"})
    private String object;
    @Inject
    private RevokePrivilegeCall revokePrivilegeCall;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.revokePrivilegeCall).inputProvider(() -> GrantRevokePrivilegeCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).roleNames(this.roleName).actions(this.action).object(this.object).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot revoke privilege")));
    }
}

