/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr.repl;

import jakarta.inject.Inject;
import java.time.Instant;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.dcr.FlushReplicationCall;
import org.gridgain.internal.cli.call.dcr.FlushReplicationCallInput;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import picocli.CommandLine;

@CommandLine.Command(name="flush", description={"Set replication flush point with provided timestamp."})
public class DcReplicationFlushReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @CommandLine.Option(names={"--flush-point"}, description={"The flush point is a timestamp in the ISO-8601 format that is used to determine whether the replicated data is sufficient. After setting a flush point, replication will be considered completed at the moment when all replicated tables have all received data older than this flush point. Example: 1970-01-01T00:00:00Z."}, required=true)
    private Instant flushPoint;
    @Inject
    private FlushReplicationCall flushReplicationCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.flushReplicationCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot set replication flush point")).print());
    }

    private FlushReplicationCallInput input(String url) {
        return FlushReplicationCallInput.builder().clusterUrl(url).replicationName(this.name.replicationName()).flushPoint(this.flushPoint).build();
    }
}

