/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.sink.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.cdc.sink.SinkNameCallInput;
import org.gridgain.internal.cli.call.cdc.sink.StatusSinkCall;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"CDC sink status command"})
public class CdcSinkStatusReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC sink."})
    private String name;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private StatusSinkCall statusSinkCall;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.statusSinkCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot get sink status")).print());
    }

    private SinkNameCallInput input(String url) {
        return SinkNameCallInput.builder().clusterUrl(url).name(this.name).build();
    }
}

