/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.user;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.UserManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.CreateUserRequest;
import org.gridgain.internal.cli.call.rbac.user.User;
import org.gridgain.internal.cli.call.rbac.user.UserCallInput;

@Singleton
public class CreateUserCall
implements Call<UserCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public CreateUserCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(UserCallInput input) {
        String clusterUrl = input.url();
        try {
            this.createUserRest(clusterUrl, input.user());
            return DefaultCallOutput.success("User " + input.user().username() + " created");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private void createUserRest(String clusterUrl, User user) throws ApiException {
        new UserManagementApi(this.apiClientFactory.getClient(clusterUrl)).createUser(new CreateUserRequest().username(user.username()).plainPassword(user.password()));
    }
}

