/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.dcr;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.DcrApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.ReplicationInfo;
import org.apache.ignite.rest.client.model.StartStopReplicationRequest;
import org.gridgain.internal.cli.call.dcr.ReplicationNameCallInput;
import org.gridgain.internal.cli.call.dcr.ReplicationStatusCall;
import org.gridgain.internal.cli.call.dcr.StartStopReplicationCallInput;

@Singleton
public class StopReplicationCall
implements Call<StartStopReplicationCallInput, ReplicationInfo> {
    private final ReplicationStatusCall statusCall;
    private final ApiClientFactory apiClientFactory;

    public StopReplicationCall(ReplicationStatusCall statusCall, ApiClientFactory apiClientFactory) {
        this.statusCall = statusCall;
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<ReplicationInfo> execute(StartStopReplicationCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            boolean success = new DcrApi(this.apiClientFactory.getClient(clusterUrl)).stopReplication(input.replicationName(), new StartStopReplicationRequest().allTables(input.allTables()).tables(input.tables()).schemaName(input.schema()));
            if (success) {
                return this.statusCall.execute(StopReplicationCall.replicationNameInput(input));
            }
            return DefaultCallOutput.failure(new IgniteCliException("Failed to stop replication " + input.replicationName() + "."));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private static ReplicationNameCallInput replicationNameInput(StartStopReplicationCallInput input) {
        return ReplicationNameCallInput.builder().replicationName(input.replicationName()).clusterUrl(input.clusterUrl()).build();
    }
}

