/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.source;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.CdcManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.Source;

@Singleton
public class ListSourcesCall
implements Call<UrlCallInput, List<Source>> {
    private final ApiClientFactory apiClientFactory;

    public ListSourcesCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<List<Source>> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            return DefaultCallOutput.success(new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).getSources());
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

