/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.replication;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.CdcManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.cdc.replication.ReplicationNameCallInput;

@Singleton
public class StopReplicationCall
implements Call<ReplicationNameCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public StopReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(ReplicationNameCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).stopCdcReplication(input.name());
            return DefaultCallOutput.success("Replication " + input.name() + " stopped.");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

