/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.ignite.rest.client.invoker.JSON;
import org.apache.ignite.rest.client.model.AuthConfig;
import org.apache.ignite.rest.client.model.SslConfig;

public class CreateReplicationRequest {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_SOURCE_CLUSTER_ADDRESSES = "sourceClusterAddresses";
    @SerializedName(value="sourceClusterAddresses")
    @Nullable
    private List<String> sourceClusterAddresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_AUTH_CONFIG = "authConfig";
    @SerializedName(value="authConfig")
    @Nullable
    private AuthConfig authConfig;
    public static final String SERIALIZED_NAME_SSL_CONFIG = "sslConfig";
    @SerializedName(value="sslConfig")
    @Nullable
    private SslConfig sslConfig;
    public static final String SERIALIZED_NAME_REPLICATION_NODES = "replicationNodes";
    @SerializedName(value="replicationNodes")
    @Nullable
    private List<String> replicationNodes = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("name", "sourceClusterAddresses", "authConfig", "sslConfig", "replicationNodes"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public CreateReplicationRequest name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public CreateReplicationRequest sourceClusterAddresses(@Nullable List<String> sourceClusterAddresses) {
        this.sourceClusterAddresses = sourceClusterAddresses;
        return this;
    }

    public CreateReplicationRequest addSourceClusterAddressesItem(String sourceClusterAddressesItem) {
        if (this.sourceClusterAddresses == null) {
            this.sourceClusterAddresses = new ArrayList<String>();
        }
        this.sourceClusterAddresses.add(sourceClusterAddressesItem);
        return this;
    }

    @Nullable
    public List<String> getSourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    public void setSourceClusterAddresses(@Nullable List<String> sourceClusterAddresses) {
        this.sourceClusterAddresses = sourceClusterAddresses;
    }

    public CreateReplicationRequest authConfig(@Nullable AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @Nullable
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public void setAuthConfig(@Nullable AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public CreateReplicationRequest sslConfig(@Nullable SslConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @Nullable
    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(@Nullable SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public CreateReplicationRequest replicationNodes(@Nullable List<String> replicationNodes) {
        this.replicationNodes = replicationNodes;
        return this;
    }

    public CreateReplicationRequest addReplicationNodesItem(String replicationNodesItem) {
        if (this.replicationNodes == null) {
            this.replicationNodes = new ArrayList<String>();
        }
        this.replicationNodes.add(replicationNodesItem);
        return this;
    }

    @Nullable
    public List<String> getReplicationNodes() {
        return this.replicationNodes;
    }

    public void setReplicationNodes(@Nullable List<String> replicationNodes) {
        this.replicationNodes = replicationNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateReplicationRequest createReplicationRequest = (CreateReplicationRequest)o;
        return Objects.equals(this.name, createReplicationRequest.name) && Objects.equals(this.sourceClusterAddresses, createReplicationRequest.sourceClusterAddresses) && Objects.equals(this.authConfig, createReplicationRequest.authConfig) && Objects.equals(this.sslConfig, createReplicationRequest.sslConfig) && Objects.equals(this.replicationNodes, createReplicationRequest.replicationNodes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.replicationNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateReplicationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceClusterAddresses: ").append(this.toIndentedString(this.sourceClusterAddresses)).append("\n");
        sb.append("    authConfig: ").append(this.toIndentedString(this.authConfig)).append("\n");
        sb.append("    sslConfig: ").append(this.toIndentedString(this.sslConfig)).append("\n");
        sb.append("    replicationNodes: ").append(this.toIndentedString(this.replicationNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in CreateReplicationRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `CreateReplicationRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_CLUSTER_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_CLUSTER_ADDRESSES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOURCE_CLUSTER_ADDRESSES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `sourceClusterAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_CLUSTER_ADDRESSES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_CONFIG).isJsonNull()) {
            AuthConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_AUTH_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_SSL_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_SSL_CONFIG).isJsonNull()) {
            SslConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SSL_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPLICATION_NODES) != null && !jsonObj.get(SERIALIZED_NAME_REPLICATION_NODES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPLICATION_NODES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `replicationNodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPLICATION_NODES).toString()));
        }
    }

    public static CreateReplicationRequest fromJson(String jsonString) throws IOException {
        return (CreateReplicationRequest)JSON.getGson().fromJson(jsonString, CreateReplicationRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateReplicationRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateReplicationRequest.class));
            return new TypeAdapter<CreateReplicationRequest>(){

                public void write(JsonWriter out, CreateReplicationRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateReplicationRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CreateReplicationRequest.validateJsonElement(jsonElement);
                    return (CreateReplicationRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

