/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import okhttp3.Call;
import org.apache.ignite.rest.client.invoker.ApiCallback;
import org.apache.ignite.rest.client.invoker.ApiClient;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.ApiResponse;
import org.apache.ignite.rest.client.invoker.Configuration;
import org.apache.ignite.rest.client.invoker.Pair;
import org.apache.ignite.rest.client.model.Transaction;

public class TransactionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call killTransactionCall(@Nonnull UUID transactionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/transactions/{transactionId}".replace("{transactionId}", this.localVarApiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call killTransactionValidateBeforeCall(@Nonnull UUID transactionId, ApiCallback _callback) throws ApiException {
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling killTransaction(Async)");
        }
        return this.killTransactionCall(transactionId, _callback);
    }

    public void killTransaction(@Nonnull UUID transactionId) throws ApiException {
        this.killTransactionWithHttpInfo(transactionId);
    }

    public ApiResponse<Void> killTransactionWithHttpInfo(@Nonnull UUID transactionId) throws ApiException {
        Call localVarCall = this.killTransactionValidateBeforeCall(transactionId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call killTransactionAsync(@Nonnull UUID transactionId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.killTransactionValidateBeforeCall(transactionId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call transactionCall(@Nonnull UUID transactionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/transactions/{transactionId}".replace("{transactionId}", this.localVarApiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transactionValidateBeforeCall(@Nonnull UUID transactionId, ApiCallback _callback) throws ApiException {
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling transaction(Async)");
        }
        return this.transactionCall(transactionId, _callback);
    }

    public Transaction transaction(@Nonnull UUID transactionId) throws ApiException {
        ApiResponse<Transaction> localVarResp = this.transactionWithHttpInfo(transactionId);
        return localVarResp.getData();
    }

    public ApiResponse<Transaction> transactionWithHttpInfo(@Nonnull UUID transactionId) throws ApiException {
        Call localVarCall = this.transactionValidateBeforeCall(transactionId, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call transactionAsync(@Nonnull UUID transactionId, ApiCallback<Transaction> _callback) throws ApiException {
        Call localVarCall = this.transactionValidateBeforeCall(transactionId, _callback);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call transactionsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transactionsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.transactionsCall(_callback);
    }

    public List<Transaction> transactions() throws ApiException {
        ApiResponse<List<Transaction>> localVarResp = this.transactionsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Transaction>> transactionsWithHttpInfo() throws ApiException {
        Call localVarCall = this.transactionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Transaction>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call transactionsAsync(ApiCallback<List<Transaction>> _callback) throws ApiException {
        Call localVarCall = this.transactionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Transaction>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

