/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import org.apache.ignite.rest.client.invoker.ApiCallback;
import org.apache.ignite.rest.client.invoker.ApiClient;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.ApiResponse;
import org.apache.ignite.rest.client.invoker.Configuration;
import org.apache.ignite.rest.client.invoker.Pair;
import org.apache.ignite.rest.client.model.CreateCommand;
import org.apache.ignite.rest.client.model.DeleteCommand;
import org.apache.ignite.rest.client.model.RestoreCommand;
import org.apache.ignite.rest.client.model.SnapshotListItem;
import org.apache.ignite.rest.client.model.SnapshotOperation;

public class SnapshotManagementApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SnapshotManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SnapshotManagementApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(@Nonnull CreateCommand createCommand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCommand localVarPostBody = createCommand;
        String localVarPath = "/management/v1/snapshot/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(@Nonnull CreateCommand createCommand, ApiCallback _callback) throws ApiException {
        if (createCommand == null) {
            throw new ApiException("Missing the required parameter 'createCommand' when calling create(Async)");
        }
        return this.createCall(createCommand, _callback);
    }

    public UUID create(@Nonnull CreateCommand createCommand) throws ApiException {
        ApiResponse<UUID> localVarResp = this.createWithHttpInfo(createCommand);
        return localVarResp.getData();
    }

    public ApiResponse<UUID> createWithHttpInfo(@Nonnull CreateCommand createCommand) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(createCommand, null);
        Type localVarReturnType = new TypeToken<UUID>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAsync(@Nonnull CreateCommand createCommand, ApiCallback<UUID> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(createCommand, _callback);
        Type localVarReturnType = new TypeToken<UUID>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCall(@Nonnull DeleteCommand deleteCommand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DeleteCommand localVarPostBody = deleteCommand;
        String localVarPath = "/management/v1/snapshot/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(@Nonnull DeleteCommand deleteCommand, ApiCallback _callback) throws ApiException {
        if (deleteCommand == null) {
            throw new ApiException("Missing the required parameter 'deleteCommand' when calling delete(Async)");
        }
        return this.deleteCall(deleteCommand, _callback);
    }

    public UUID delete(@Nonnull DeleteCommand deleteCommand) throws ApiException {
        ApiResponse<UUID> localVarResp = this.deleteWithHttpInfo(deleteCommand);
        return localVarResp.getData();
    }

    public ApiResponse<UUID> deleteWithHttpInfo(@Nonnull DeleteCommand deleteCommand) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(deleteCommand, null);
        Type localVarReturnType = new TypeToken<UUID>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAsync(@Nonnull DeleteCommand deleteCommand, ApiCallback<UUID> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(deleteCommand, _callback);
        Type localVarReturnType = new TypeToken<UUID>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListCall(@Nonnull Boolean showNodeNames, @Nonnull Boolean showTableNames, @Nonnull Boolean showSourceUri, @Nullable String source, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/snapshot/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (source != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("source", source));
        }
        if (showNodeNames != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("showNodeNames", showNodeNames));
        }
        if (showTableNames != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("showTableNames", showTableNames));
        }
        if (showSourceUri != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("showSourceUri", showSourceUri));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListValidateBeforeCall(@Nonnull Boolean showNodeNames, @Nonnull Boolean showTableNames, @Nonnull Boolean showSourceUri, @Nullable String source, ApiCallback _callback) throws ApiException {
        if (showNodeNames == null) {
            throw new ApiException("Missing the required parameter 'showNodeNames' when calling getList(Async)");
        }
        if (showTableNames == null) {
            throw new ApiException("Missing the required parameter 'showTableNames' when calling getList(Async)");
        }
        if (showSourceUri == null) {
            throw new ApiException("Missing the required parameter 'showSourceUri' when calling getList(Async)");
        }
        return this.getListCall(showNodeNames, showTableNames, showSourceUri, source, _callback);
    }

    public List<SnapshotListItem> getList(@Nonnull Boolean showNodeNames, @Nonnull Boolean showTableNames, @Nonnull Boolean showSourceUri, @Nullable String source) throws ApiException {
        ApiResponse<List<SnapshotListItem>> localVarResp = this.getListWithHttpInfo(showNodeNames, showTableNames, showSourceUri, source);
        return localVarResp.getData();
    }

    public ApiResponse<List<SnapshotListItem>> getListWithHttpInfo(@Nonnull Boolean showNodeNames, @Nonnull Boolean showTableNames, @Nonnull Boolean showSourceUri, @Nullable String source) throws ApiException {
        Call localVarCall = this.getListValidateBeforeCall(showNodeNames, showTableNames, showSourceUri, source, null);
        Type localVarReturnType = new TypeToken<List<SnapshotListItem>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListAsync(@Nonnull Boolean showNodeNames, @Nonnull Boolean showTableNames, @Nonnull Boolean showSourceUri, @Nullable String source, ApiCallback<List<SnapshotListItem>> _callback) throws ApiException {
        Call localVarCall = this.getListValidateBeforeCall(showNodeNames, showTableNames, showSourceUri, source, _callback);
        Type localVarReturnType = new TypeToken<List<SnapshotListItem>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOperationByIdCall(@Nonnull UUID operationId, @Nonnull Boolean allNodes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/snapshot/operations/{operationId}".replace("{operationId}", this.localVarApiClient.escapeString(operationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allNodes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allNodes", allNodes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOperationByIdValidateBeforeCall(@Nonnull UUID operationId, @Nonnull Boolean allNodes, ApiCallback _callback) throws ApiException {
        if (operationId == null) {
            throw new ApiException("Missing the required parameter 'operationId' when calling getOperationById(Async)");
        }
        if (allNodes == null) {
            throw new ApiException("Missing the required parameter 'allNodes' when calling getOperationById(Async)");
        }
        return this.getOperationByIdCall(operationId, allNodes, _callback);
    }

    public List<SnapshotOperation> getOperationById(@Nonnull UUID operationId, @Nonnull Boolean allNodes) throws ApiException {
        ApiResponse<List<SnapshotOperation>> localVarResp = this.getOperationByIdWithHttpInfo(operationId, allNodes);
        return localVarResp.getData();
    }

    public ApiResponse<List<SnapshotOperation>> getOperationByIdWithHttpInfo(@Nonnull UUID operationId, @Nonnull Boolean allNodes) throws ApiException {
        Call localVarCall = this.getOperationByIdValidateBeforeCall(operationId, allNodes, null);
        Type localVarReturnType = new TypeToken<List<SnapshotOperation>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOperationByIdAsync(@Nonnull UUID operationId, @Nonnull Boolean allNodes, ApiCallback<List<SnapshotOperation>> _callback) throws ApiException {
        Call localVarCall = this.getOperationByIdValidateBeforeCall(operationId, allNodes, _callback);
        Type localVarReturnType = new TypeToken<List<SnapshotOperation>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOperationsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/snapshot/operations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOperationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getOperationsCall(_callback);
    }

    public List<SnapshotOperation> getOperations() throws ApiException {
        ApiResponse<List<SnapshotOperation>> localVarResp = this.getOperationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<SnapshotOperation>> getOperationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getOperationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<SnapshotOperation>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOperationsAsync(ApiCallback<List<SnapshotOperation>> _callback) throws ApiException {
        Call localVarCall = this.getOperationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<SnapshotOperation>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call restoreCall(@Nonnull RestoreCommand restoreCommand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestoreCommand localVarPostBody = restoreCommand;
        String localVarPath = "/management/v1/snapshot/restore";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restoreValidateBeforeCall(@Nonnull RestoreCommand restoreCommand, ApiCallback _callback) throws ApiException {
        if (restoreCommand == null) {
            throw new ApiException("Missing the required parameter 'restoreCommand' when calling restore(Async)");
        }
        return this.restoreCall(restoreCommand, _callback);
    }

    public UUID restore(@Nonnull RestoreCommand restoreCommand) throws ApiException {
        ApiResponse<UUID> localVarResp = this.restoreWithHttpInfo(restoreCommand);
        return localVarResp.getData();
    }

    public ApiResponse<UUID> restoreWithHttpInfo(@Nonnull RestoreCommand restoreCommand) throws ApiException {
        Call localVarCall = this.restoreValidateBeforeCall(restoreCommand, null);
        Type localVarReturnType = new TypeToken<UUID>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call restoreAsync(@Nonnull RestoreCommand restoreCommand, ApiCallback<UUID> _callback) throws ApiException {
        Call localVarCall = this.restoreValidateBeforeCall(restoreCommand, _callback);
        Type localVarReturnType = new TypeToken<UUID>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

