/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryImplBase<T>
implements ConnectionEventListener {
    private final AtomicReference<String> lastKnownUrl = new AtomicReference<Object>(null);
    @Nullable
    private LazyObjectRef<T> ref;

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.lastKnownUrl.set(sessionInfo.nodeUrl());
        this.updateState();
    }

    private void updateState() {
        String lastKnownUrl = this.lastKnownUrl.get();
        if (lastKnownUrl != null) {
            this.ref = new LazyObjectRef<Object>(() -> this.doGetState(lastKnownUrl));
        }
    }

    @Nullable
    protected abstract T doGetState(String var1);

    @Override
    public void onDisconnect() {
        this.ref = null;
    }

    @Nullable
    protected T getResult() {
        return this.ref != null ? (T)this.ref.get() : null;
    }

    public void refresh() {
        this.updateState();
    }
}

