/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl;

import io.micronaut.context.annotation.Value;
import jakarta.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;
import org.apache.ignite.internal.cli.event.EventPublisher;
import org.apache.ignite.internal.cli.event.Events;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.rest.client.api.NodeManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ConnectionHeartBeat
implements ConnectionEventListener {
    private static final IgniteLogger LOG = CliLoggers.forClass(ConnectionHeartBeat.class);
    private final long cliCheckConnectionPeriodSecond;
    @Nullable
    private ScheduledExecutorService scheduledConnectionHeartbeatExecutor;
    private final ApiClientFactory clientFactory;
    private final EventPublisher eventPublisher;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicReference<String> lastKnownUrl = new AtomicReference<Object>(null);
    private final Lock lock = new ReentrantLock();

    public ConnectionHeartBeat(@Value(value="${cli.check.connection.period.second:5}") long cliCheckConnectionPeriodSecond, ApiClientFactory clientFactory, EventPublisher eventPublisher) {
        this.clientFactory = clientFactory;
        this.eventPublisher = eventPublisher;
        this.cliCheckConnectionPeriodSecond = cliCheckConnectionPeriodSecond;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        if (this.connected.compareAndSet(false, true)) {
            this.eventPublisher.publish(Events.connectionRestored());
        }
        this.lastKnownUrl.set(sessionInfo.nodeUrl());
        this.lock.lock();
        try {
            if (this.scheduledConnectionHeartbeatExecutor == null) {
                this.scheduledConnectionHeartbeatExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("cli-check-connection-thread", LOG));
                this.scheduledConnectionHeartbeatExecutor.scheduleAtFixedRate(this::pingConnection, 0L, this.cliCheckConnectionPeriodSecond, TimeUnit.SECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onDisconnect() {
        this.lock.lock();
        try {
            if (this.scheduledConnectionHeartbeatExecutor != null) {
                this.scheduledConnectionHeartbeatExecutor.shutdownNow();
                this.scheduledConnectionHeartbeatExecutor = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pingConnection() {
        block4: {
            try {
                new NodeManagementApi(this.clientFactory.getClient(this.lastKnownUrl.get())).nodeState();
                if (this.connected.compareAndSet(false, true)) {
                    this.eventPublisher.publish(Events.connectionRestored());
                }
            }
            catch (ApiException exception) {
                if (!this.connected.compareAndSet(true, false)) break block4;
                int code = exception.getCode();
                if (code == HttpCode.UNAUTHORIZED.code()) {
                    this.eventPublisher.publish(Events.disconnect());
                }
                this.eventPublisher.publish(Events.connectionLost());
            }
        }
    }
}

