/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.sql.SqlExecReplCommand;
import org.apache.ignite.internal.cli.commands.sql.planner.SqlPlannerReplCommand;
import picocli.CommandLine;

@CommandLine.Command(name="sql", subcommands={SqlPlannerReplCommand.class}, description={"SQL query engine operations."})
public class SqlReplCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--jdbc-url"}, descriptionKey="ignite.jdbc-url", description={"JDBC url to ignite cluster. For example, 'jdbc:ignite:thin://127.0.0.1:10800'"})
    private String jdbc;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @CommandLine.Option(names={"--timed"}, description={"Display query execution time (measured on the client) after the output"})
    private boolean timed;
    @CommandLine.Option(names={"--file"}, description={"Path to file with SQL commands to execute"})
    private String file;
    @CommandLine.Unmatched
    private String[] args;

    @Override
    public Integer call() throws Exception {
        CommandLine.IFactory factory = this.spec.commandLine().getFactory();
        CommandLine commandLine = new CommandLine(factory.create(SqlExecReplCommand.class), factory).setErr(this.spec.commandLine().getErr()).setOut(this.spec.commandLine().getOut()).setDefaultValueProvider(this.spec.defaultValueProvider()).setExecutionExceptionHandler(this.spec.commandLine().getExecutionExceptionHandler());
        return commandLine.execute(this.buildArgs());
    }

    private String[] buildArgs() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.args != null) {
            Collections.addAll(result, this.args);
        }
        if (this.jdbc != null) {
            result.add("--jdbc-url=" + this.jdbc);
        }
        if (this.plain) {
            result.add("--plain");
        }
        if (this.timed) {
            result.add("--timed");
        }
        if (this.file != null) {
            result.add("--file=" + this.file);
        }
        return result.toArray(new String[0]);
    }
}

