/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.recovery.restart;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.recovery.restart.RestartPartitionsCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.RecoveryApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.RestartZonePartitionsRequest;

@Singleton
public class RestartPartitionsCall
implements Call<RestartPartitionsCallInput, String> {
    private final ApiClientFactory clientFactory;

    public RestartPartitionsCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(RestartPartitionsCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()).setReadTimeout(30000));
        try {
            RestartZonePartitionsRequest command = new RestartZonePartitionsRequest();
            command.setPartitionIds(input.partitionIds());
            command.setNodeNames(input.nodeNames());
            command.setZoneName(input.zoneName());
            if (input.withCleanup()) {
                client.restartZonePartitionsWithCleanup(command);
            } else {
                client.restartZonePartitions(command);
            }
            return DefaultCallOutput.success("Successfully restarted partitions.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

