/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.status;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.decorators.TableDecorator;
import org.gridgain.internal.cli.call.snapshot.SnapshotStatusCall;
import org.gridgain.internal.cli.commands.snapshot.status.SnapshotStatusMixin;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Returns snapshot operations"})
public class SnapshotStatusReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @CommandLine.Mixin
    private SnapshotStatusMixin options;
    @Inject
    private SnapshotStatusCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(clusterUrl -> this.options.buildCallInput(this.spec.commandLine(), (String)clusterUrl)).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot show snapshot operations")).print(new TableDecorator(this.plain)));
    }
}

