/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.create;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.snapshot.SnapshotCreateCall;
import org.gridgain.internal.cli.call.snapshot.SnapshotCreateCallInput;
import org.gridgain.internal.cli.commands.snapshot.create.SnapshotCreateMixin;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates new snapshot"})
public class SnapshotCreateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private SnapshotCreateMixin options;
    @Inject
    private SnapshotCreateCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot create snapshot")).print());
    }

    private SnapshotCreateCallInput buildCallInput(String clusterUrl) {
        return SnapshotCreateCallInput.builder().snapshotType(this.options.snapshotType()).tableNames(this.options.tableArgs().tableNames()).structureNames(this.options.tableArgs().structureNames()).timestamp(this.options.timestampValue()).destination(this.options.destination()).all(this.options.tableArgs().all()).encryptionProvider(this.options.encryptionProvider()).clusterUrl(clusterUrl).build();
    }
}

