/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.privilege;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.assignments.GrantPrivilegeCall;
import org.gridgain.internal.cli.call.rbac.assignments.GrantRevokePrivilegeCallInput;
import org.gridgain.internal.cli.call.rbac.privilege.Action;
import org.gridgain.internal.cli.core.converters.ActionConverter;
import picocli.CommandLine;

@CommandLine.Command(name="grant", description={"Grant privilege to role"})
public class RolePrivilegeGrantCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--to"}, description={"To role name"}, required=true, split=",")
    private List<String> roleName;
    @CommandLine.Option(names={"--action"}, description={"Action"}, required=true, converter={ActionConverter.class}, split=",")
    private List<Action> action;
    @CommandLine.Option(names={"--on"}, description={"Object"})
    private String object;
    @Inject
    private GrantPrivilegeCall grantPrivilegeCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.grantPrivilegeCall).inputProvider(() -> GrantRevokePrivilegeCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).roleNames(this.roleName).actions(this.action).object(this.object).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot grant privilege")));
    }
}

