/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.license.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.decorators.DefaultDecorator;
import org.gridgain.internal.cli.call.license.UpdateLicenseCall;
import org.gridgain.internal.cli.call.license.UpdateLicenseCallInput;
import org.gridgain.internal.cli.commands.license.LicenseUpdateOptions;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Update license"})
public class LicenseUpdateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private LicenseUpdateOptions options;
    @Inject
    private UpdateLicenseCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).verbose(this.verbose).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot update license")).print(new DefaultDecorator()).start();
    }

    private UpdateLicenseCallInput buildCallInput(String clusterUrl) {
        return UpdateLicenseCallInput.builder().clusterUrl(clusterUrl).licenseFile(this.options.license()).build();
    }
}

