/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr.repl;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.rest.client.model.AuthConfig;
import org.apache.ignite.rest.client.model.SslConfig;
import org.gridgain.internal.cli.call.dcr.CreateReplicationCallInput;
import org.gridgain.internal.cli.call.dcr.CreateReplicationReplCall;
import org.gridgain.internal.cli.commands.dcr.DcReplicationAuthConfigGroup;
import org.gridgain.internal.cli.commands.dcr.DcrReplicationSslConfigGroup;
import org.gridgain.internal.cli.decorators.ReplicationInfoDecorator;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create data center replication."})
public class DcReplicationCreateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--name"}, description={"The unique name of the replication. Should be without whitespaces."}, required=true)
    private String name;
    @CommandLine.Option(names={"--source-cluster-address"}, description={"Comma-separated list of client addresses of the cluster that is a source cluster for the replication. Example: localhost:10800,localhost:10801"}, required=true, split=",")
    private List<String> sourceClusterAddresses;
    @CommandLine.ArgGroup(exclusive=false)
    @Nullable
    private DcReplicationAuthConfigGroup authConfig;
    @CommandLine.ArgGroup(exclusive=false)
    @Nullable
    private DcrReplicationSslConfigGroup sslConfig;
    @CommandLine.Option(names={"--replication-nodes"}, description={"Comma-separated replication nodes names, worker node will be chosen from the list of replication nodes."}, split=",")
    private List<String> replicationNodes;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private CreateReplicationReplCall createReplicationCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.createReplicationCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot create replication")).print(new ReplicationInfoDecorator(this.plain)));
    }

    private CreateReplicationCallInput input(String url) {
        return CreateReplicationCallInput.builder().name(this.name).authConfig(DcReplicationCreateReplCommand.toRequestAuthConfig(this.authConfig)).sslConfig(DcReplicationCreateReplCommand.toRequestSslConfig(this.sslConfig)).sourceClusterAddresses(this.sourceClusterAddresses).replicationNodes(this.replicationNodes).clusterUrl(url).build();
    }

    @Nullable
    private static AuthConfig toRequestAuthConfig(@Nullable DcReplicationAuthConfigGroup authConfig) {
        if (authConfig == null) {
            return null;
        }
        return new AuthConfig().username(authConfig.username()).password(authConfig.password());
    }

    @Nullable
    private static SslConfig toRequestSslConfig(@Nullable DcrReplicationSslConfigGroup sslConfig) {
        if (sslConfig == null) {
            return null;
        }
        return new SslConfig().keyStorePath(sslConfig.keyStorePath()).keyStorePassword(sslConfig.keyStorePassword()).trustStorePath(sslConfig.trustStorePath()).trustStorePassword(sslConfig.trustStorePassword());
    }
}

