/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.dcr;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.DcrApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.CreateReplicationRequest;
import org.apache.ignite.rest.client.model.ReplicationInfo;
import org.gridgain.internal.cli.call.dcr.CreateReplicationCallInput;

@Singleton
public class CreateReplicationCall
implements Call<CreateReplicationCallInput, ReplicationInfo> {
    private final ApiClientFactory apiClientFactory;

    public CreateReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<ReplicationInfo> execute(CreateReplicationCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            ReplicationInfo replicationInfo = new DcrApi(this.apiClientFactory.getClient(clusterUrl)).createReplication(CreateReplicationCall.createReplicationRequest(input));
            return DefaultCallOutput.success(replicationInfo);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private static CreateReplicationRequest createReplicationRequest(CreateReplicationCallInput input) {
        return new CreateReplicationRequest().name(input.name()).authConfig(input.authConfig()).sslConfig(input.sslConfig()).replicationNodes(input.replicationNodes()).sourceClusterAddresses(input.sourceClusterAddresses());
    }
}

