/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.sql.SqlQueryResultItem;
import org.apache.ignite.internal.cli.sql.SqlQueryResultMessage;
import org.apache.ignite.internal.cli.sql.SqlQueryResultTable;
import org.apache.ignite.internal.cli.table.Table;

public class SqlQueryResult {
    private final List<SqlQueryResultItem> sqlQueryResultItems;
    private final long durationMs;

    private SqlQueryResult(List<SqlQueryResultItem> sqlQueryResultItems, long durationMs) {
        this.sqlQueryResultItems = sqlQueryResultItems;
        this.durationMs = durationMs;
    }

    public TerminalOutput getResult(boolean plain, boolean timed) {
        return () -> {
            Object result = this.sqlQueryResultItems.stream().map(x -> x.decorate(plain).toTerminalString()).collect(Collectors.joining(""));
            if (timed) {
                result = (String)result + "Query executed in " + this.durationMs + "ms (client-side).\n";
            }
            return result;
        };
    }

    public TerminalOutput getResult(boolean plain) {
        return this.getResult(plain, false);
    }

    static class SqlQueryResultBuilder {
        private final List<SqlQueryResultItem> sqlQueryResultItems = new ArrayList<SqlQueryResultItem>();
        private long durationMs;

        SqlQueryResultBuilder() {
        }

        void addTable(Table<String> table) {
            this.sqlQueryResultItems.add(new SqlQueryResultTable(table));
        }

        void addMessage(String message) {
            this.sqlQueryResultItems.add(new SqlQueryResultMessage(message + "\n"));
        }

        void setDurationMs(long durationMs) {
            this.durationMs = durationMs;
        }

        public SqlQueryResult build() {
            return new SqlQueryResult(this.sqlQueryResultItems, this.durationMs);
        }
    }
}

