/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.rest;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientSettings;
import org.apache.ignite.internal.cli.core.rest.ApiClientSettingsBuilder;
import org.apache.ignite.internal.cli.core.rest.ReAuthApiCallback;
import org.apache.ignite.internal.cli.core.rest.TokenStore;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.rest.client.api.AuthenticationApi;
import org.apache.ignite.rest.client.invoker.ApiCallback;
import org.apache.ignite.rest.client.invoker.ApiClient;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.ApiResponse;
import org.apache.ignite.rest.client.model.LoginBody;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ApiClientFactory
implements ConnectionEventListener {
    private static final Pattern INCORRECT_PASSWORD_PATTERN = Pattern.compile(".*keystore password was incorrect.*");
    private final Map<ApiClientSettings, ApiClient> clientMap = new ConcurrentHashMap<ApiClientSettings, ApiClient>();
    private final AtomicReference<ApiClientSettings> currentSessionSettings = new AtomicReference();
    private final ConfigManagerProvider configManagerProvider;
    private final TokenStore tokenStore;
    private boolean tokenRenewModeEnabled = false;

    public ApiClientFactory(ConfigManagerProvider configManagerProvider, TokenStore tokenStore) {
        this.configManagerProvider = configManagerProvider;
        this.tokenStore = tokenStore;
    }

    @Override
    public void onDisconnect() {
        this.setSessionSettings(null);
        this.clientMap.clear();
    }

    public void tokenAutoRenewEnabled(boolean enabled) {
        this.tokenRenewModeEnabled = enabled;
    }

    public ApiClient getClient(String path) {
        return this.getClientFromSettings(this.settingsWithAuth(path));
    }

    @PreDestroy
    private void clearLoggers() {
        CliLoggers.clearLoggers();
    }

    private ApiClient getClientFromSettings(ApiClientSettings settings) {
        ApiClient apiClient = this.clientMap.computeIfAbsent(settings, this::buildClient);
        CliLoggers.addApiClient(apiClient);
        return apiClient;
    }

    private ApiClientSettings settingsWithAuth(String path) {
        ConfigManager configManager = this.configManagerProvider.get();
        ApiClientSettingsBuilder builder = ApiClientSettings.builder().basePath(path).keyStorePath(configManager.getCurrentProperty(CliConfigKeys.REST_KEY_STORE_PATH.value())).keyStorePassword(configManager.getCurrentProperty(CliConfigKeys.REST_KEY_STORE_PASSWORD.value())).trustStorePath(configManager.getCurrentProperty(CliConfigKeys.REST_TRUST_STORE_PATH.value())).trustStorePassword(configManager.getCurrentProperty(CliConfigKeys.REST_TRUST_STORE_PASSWORD.value())).ciphers(configManager.getCurrentProperty(CliConfigKeys.REST_CIPHERS.value()));
        return this.setupAuthentication(builder).build();
    }

    private ApiClientSettingsBuilder setupAuthentication(ApiClientSettingsBuilder builder) {
        ConfigManager configManager = this.configManagerProvider.get();
        ApiClientSettings currentCredentialsSettings = this.currentSessionSettings();
        String username = currentCredentialsSettings != null ? currentCredentialsSettings.basicAuthenticationUsername() : configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value());
        String password = currentCredentialsSettings != null ? currentCredentialsSettings.basicAuthenticationPassword() : configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD.value());
        builder.basicAuthenticationUsername(username).basicAuthenticationPassword(password).token(this.tokenStore.getCurrentToken());
        return builder;
    }

    public ApiClient buildClient(ApiClientSettings settings) {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.retryOnConnectionFailure(false);
            if (!StringUtils.nullOrBlank((String)settings.trustStorePath()) || !StringUtils.nullOrBlank((String)settings.trustStorePassword())) {
                ApiClientFactory.applySslSettings(builder, settings);
            }
            OkHttpClient okHttpClient = builder.build();
            ApiClient apiClient = settings.hasAuthentication() ? this.apiClientWithAuth(okHttpClient, settings) : new ApiClient(okHttpClient);
            return apiClient.setBasePath(settings.basePath());
        }
        catch (Exception e) {
            throw new IgniteCliApiException(e, settings.basePath());
        }
    }

    private ApiClient apiClientWithAuth(OkHttpClient okHttpClient, ApiClientSettings settings) {
        ApiClient apiClient;
        String token = settings.token();
        if (this.tokenRenewModeEnabled) {
            apiClient = this.apiClientWithTokenRenew(settings, okHttpClient);
            apiClient.setBearerToken(token);
        } else {
            apiClient = new ApiClient(okHttpClient);
            if (token != null) {
                apiClient.setBearerToken(token);
            } else {
                apiClient.setUsername(settings.basicAuthenticationUsername());
                apiClient.setPassword(settings.basicAuthenticationPassword());
            }
        }
        return apiClient;
    }

    private ApiClient apiClientWithTokenRenew(final ApiClientSettings settings, OkHttpClient okHttpClient) {
        return new ApiClient(okHttpClient){
            private boolean shouldRetry;
            {
                super(client);
                this.shouldRetry = true;
            }

            @Override
            public <T> ApiResponse<T> execute(Call call, Type returnType) throws ApiException {
                try {
                    ApiResponse apiResponse = super.execute(call, returnType);
                    return apiResponse;
                }
                catch (ApiException e) {
                    if (e.getCode() == 401 && !ApiClientFactory.this.tokenStore.isTokenPersisted() && this.shouldRetry) {
                        this.shouldRetry = false;
                        ApiResponse apiResponse = super.execute(this.renewToken(call), returnType);
                        return apiResponse;
                    }
                    throw e;
                }
                finally {
                    this.shouldRetry = true;
                }
            }

            @Override
            public <T> void executeAsync(Call call, Type returnType, ApiCallback<T> callback) {
                ReAuthApiCallback<T> callbackWrapper = new ReAuthApiCallback<T>(callback, ApiClientFactory.this.tokenStore, () -> {
                    try {
                        super.executeAsync(this.renewToken(call), returnType, callback);
                    }
                    catch (ApiException e) {
                        callback.onFailure(e, 0, null);
                    }
                });
                super.executeAsync(call, returnType, callbackWrapper);
            }

            private Call renewToken(Call call) throws ApiException {
                String newToken = ApiClientFactory.login(this, settings);
                ApiClientFactory.this.tokenStore.setToken(newToken);
                this.setBearerToken(newToken);
                return this.getHttpClient().newCall(call.request().newBuilder().removeHeader("Authorization").addHeader("Authorization", "Bearer " + newToken).build());
            }
        };
    }

    private static String login(ApiClient client, ApiClientSettings settings) throws ApiException {
        return new AuthenticationApi(client).login(new LoginBody().username(settings.basicAuthenticationUsername()).password(settings.basicAuthenticationPassword()));
    }

    public void setSessionSettings(@Nullable ApiClientSettings settings) {
        if (settings != null) {
            this.currentSessionSettings.compareAndSet(null, settings);
        } else {
            this.currentSessionSettings.set(null);
        }
    }

    public ApiClientSettings currentSessionSettings() {
        return this.currentSessionSettings.get();
    }

    private static void applySslSettings(OkHttpClient.Builder builder, ApiClientSettings settings) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        TrustManagerFactory trustManagerFactory = ApiClientFactory.trustManagerFactory(settings);
        KeyManagerFactory keyManagerFactory = ApiClientFactory.keyManagerFactory(settings);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        ApiClientFactory.setCiphers(builder, settings);
        builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
    }

    private static KeyManagerFactory keyManagerFactory(ApiClientSettings settings) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (StringUtils.nullOrBlank((String)settings.keyStorePath())) {
                keyManagerFactory.init(null, null);
            } else {
                char[] password = settings.keyStorePassword() == null ? null : settings.keyStorePassword().toCharArray();
                KeyStore keyStore = KeyStore.getInstance(new File(settings.keyStorePath()), password);
                keyManagerFactory.init(keyStore, password);
            }
            return keyManagerFactory;
        }
        catch (IOException e) {
            if (INCORRECT_PASSWORD_PATTERN.matcher(e.getMessage()).matches()) {
                throw new IOException("Key-store password was incorrect", e.getCause());
            }
            throw e;
        }
    }

    private static TrustManagerFactory trustManagerFactory(ApiClientSettings settings) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (StringUtils.nullOrBlank((String)settings.trustStorePath())) {
                trustManagerFactory.init((KeyStore)null);
            } else {
                char[] password = settings.trustStorePassword() == null ? null : settings.trustStorePassword().toCharArray();
                KeyStore trustStore = KeyStore.getInstance(new File(settings.trustStorePath()), password);
                trustManagerFactory.init(trustStore);
            }
            return trustManagerFactory;
        }
        catch (IOException e) {
            if (INCORRECT_PASSWORD_PATTERN.matcher(e.getMessage()).matches()) {
                throw new IOException("Trust-store password was incorrect", e.getCause());
            }
            throw e;
        }
    }

    private static void setCiphers(OkHttpClient.Builder builder, ApiClientSettings settings) {
        if (!StringUtils.nullOrBlank((String)settings.ciphers())) {
            List cipherSuites = Arrays.stream(settings.ciphers().split(",")).map(String::strip).collect(Collectors.toList());
            ConnectionSpec spec = new ConnectionSpec.Builder(true).cipherSuites((String[])cipherSuites.toArray(String[]::new)).build();
            builder.connectionSpecs(List.of(spec));
        }
    }
}

