/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import jakarta.inject.Singleton;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.call.cluster.topology.PhysicalTopologyCall;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.repl.PeriodicSessionTask;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.repl.registry.NodeNameRegistry;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.rest.client.model.ClusterNode;
import org.apache.ignite.rest.client.model.NodeMetadata;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NodeNameRegistryImpl
implements NodeNameRegistry,
PeriodicSessionTask {
    private static final IgniteLogger LOG = CliLoggers.forClass(NodeNameRegistryImpl.class);
    private final PhysicalTopologyCall physicalTopologyCall;
    private volatile Map<String, String> nodeNameToNodeUrl = Map.of();

    public NodeNameRegistryImpl(PhysicalTopologyCall physicalTopologyCall) {
        this.physicalTopologyCall = physicalTopologyCall;
    }

    @Override
    public Optional<String> nodeUrlByName(String nodeName) {
        return Optional.ofNullable(this.nodeNameToNodeUrl.get(nodeName));
    }

    @Override
    public Set<String> names() {
        return this.nodeNameToNodeUrl.keySet();
    }

    @Override
    public Set<String> urls() {
        return new HashSet<String>(this.nodeNameToNodeUrl.values());
    }

    @Override
    public void update(SessionInfo sessionInfo) {
        this.nodeNameToNodeUrl = this.physicalTopologyCall.execute(new UrlCallInput(sessionInfo.nodeUrl())).body().stream().map(NodeNameRegistryImpl::toNodeNameAndUrlPair).filter(it -> it.url != null).collect(Collectors.toUnmodifiableMap(it -> it.name, it -> it.url));
    }

    @Override
    public void onDisconnect() {
        this.nodeNameToNodeUrl = Map.of();
    }

    private static NodeNameAndUrlPair toNodeNameAndUrlPair(ClusterNode node) {
        return new NodeNameAndUrlPair(node.getName(), NodeNameRegistryImpl.urlFromClusterNode(node.getMetadata()));
    }

    @Nullable
    static String urlFromClusterNode(@Nullable NodeMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        try {
            Integer httpsPort = metadata.getHttpsPort();
            if (httpsPort != -1) {
                return new URL("https://" + metadata.getRestHost() + ":" + httpsPort).toString();
            }
            return new URL("http://" + metadata.getRestHost() + ":" + metadata.getHttpPort()).toString();
        }
        catch (Exception e) {
            LOG.warn("Couldn't create URL: {}", (Throwable)e);
            return null;
        }
    }

    private static class NodeNameAndUrlPair {
        private final String name;
        private final String url;

        private NodeNameAndUrlPair(String name, @Nullable String url) {
            this.name = name;
            this.url = url;
        }
    }
}

