/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.zone.datanodes;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.management.zone.ResetDataNodesCall;
import org.apache.ignite.internal.cli.call.management.zone.ResetDataNodesCallInput;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.commands.zone.datanodes.ResetDataNodesMixin;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="reset", description={"Resets data nodes for distribution zones"})
public class ResetDataNodesReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private ResetDataNodesMixin options;
    @Inject
    private ResetDataNodesCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::resetDataNodesCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot reset data nodes")).print());
    }

    private ResetDataNodesCallInput resetDataNodesCallInput(String clusterUrl) {
        return ResetDataNodesCallInput.of(this.options, clusterUrl);
    }
}

