/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.recovery.restart;

import java.util.List;
import org.apache.ignite.internal.cli.commands.recovery.partitions.restart.RestartPartitionsMixin;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.jetbrains.annotations.Nullable;

public class RestartPartitionsCallInput
implements CallInput {
    private final String clusterUrl;
    private final String zoneName;
    private final List<String> nodeNames;
    private final List<Integer> partitionIds;
    private final boolean withCleanup;

    public String clusterUrl() {
        return this.clusterUrl;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public List<Integer> partitionIds() {
        return this.partitionIds;
    }

    public List<String> nodeNames() {
        return this.nodeNames;
    }

    public boolean withCleanup() {
        return this.withCleanup;
    }

    private RestartPartitionsCallInput(String clusterUrl, String zoneName, @Nullable List<Integer> partitionIds, @Nullable List<String> nodeNames, boolean withCleanup) {
        this.clusterUrl = clusterUrl;
        this.zoneName = zoneName;
        this.partitionIds = partitionIds == null ? List.of() : List.copyOf(partitionIds);
        this.nodeNames = nodeNames == null ? List.of() : List.copyOf(nodeNames);
        this.withCleanup = withCleanup;
    }

    public static RestartPartitionsCallInput of(RestartPartitionsMixin restartArgs, String clusterUrl) {
        return RestartPartitionsCallInput.builder().zoneName(restartArgs.zoneName()).partitionIds(restartArgs.partitionIds()).nodeNames(restartArgs.nodeNames()).withCleanup(restartArgs.withCleanup()).clusterUrl(clusterUrl).build();
    }

    private static RestartPartitionsCallInputBuilder builder() {
        return new RestartPartitionsCallInputBuilder();
    }

    private static class RestartPartitionsCallInputBuilder {
        private String clusterUrl;
        private String zoneName;
        @Nullable
        private List<Integer> partitionIds;
        @Nullable
        private List<String> nodeNames;
        private boolean withCleanup;

        private RestartPartitionsCallInputBuilder() {
        }

        RestartPartitionsCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        RestartPartitionsCallInputBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        RestartPartitionsCallInputBuilder partitionIds(@Nullable List<Integer> partitionIds) {
            this.partitionIds = partitionIds;
            return this;
        }

        RestartPartitionsCallInputBuilder nodeNames(@Nullable List<String> nodeNames) {
            this.nodeNames = nodeNames;
            return this;
        }

        RestartPartitionsCallInputBuilder withCleanup(boolean withCleanup) {
            this.withCleanup = withCleanup;
            return this;
        }

        RestartPartitionsCallInput build() {
            return new RestartPartitionsCallInput(this.clusterUrl, this.zoneName, this.partitionIds, this.nodeNames, this.withCleanup);
        }
    }
}

