/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.recovery.reset;

import java.util.List;
import org.apache.ignite.internal.cli.commands.recovery.partitions.reset.ResetPartitionsMixin;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.jetbrains.annotations.Nullable;

public class ResetPartitionsCallInput
implements CallInput {
    private final String clusterUrl;
    private final String zoneName;
    private final List<Integer> partitionIds;

    public String clusterUrl() {
        return this.clusterUrl;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public List<Integer> partitionIds() {
        return this.partitionIds;
    }

    private ResetPartitionsCallInput(String clusterUrl, String zoneName, @Nullable List<Integer> partitionIds) {
        this.clusterUrl = clusterUrl;
        this.zoneName = zoneName;
        this.partitionIds = partitionIds == null ? List.of() : List.copyOf(partitionIds);
    }

    public static ResetPartitionsCallInput of(ResetPartitionsMixin statesArgs, String clusterUrl) {
        return ResetPartitionsCallInput.builder().zoneName(statesArgs.zoneName()).partitionIds(statesArgs.partitionIds()).clusterUrl(clusterUrl).build();
    }

    private static ResetPartitionsCallInputBuilder builder() {
        return new ResetPartitionsCallInputBuilder();
    }

    private static class ResetPartitionsCallInputBuilder {
        private String clusterUrl;
        private String zoneName;
        @Nullable
        private List<Integer> partitionIds;

        private ResetPartitionsCallInputBuilder() {
        }

        ResetPartitionsCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        ResetPartitionsCallInputBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        ResetPartitionsCallInputBuilder partitionIds(@Nullable List<Integer> partitionIds) {
            this.partitionIds = partitionIds;
            return this;
        }

        ResetPartitionsCallInput build() {
            return new ResetPartitionsCallInput(this.clusterUrl, this.zoneName, this.partitionIds);
        }
    }
}

