/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.connect;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.call.connect.SslConfig;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.core.JdbcUrlFactory;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.internal.cli.core.rest.ApiClientSettings;
import org.apache.ignite.internal.cli.core.rest.ApiClientSettingsBuilder;
import org.apache.ignite.internal.cli.core.rest.TokenStore;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.rest.client.api.NodeManagementApi;
import org.apache.ignite.rest.client.invoker.ApiClient;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.NodeInfo;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ConnectionChecker {
    private final JdbcUrlFactory jdbcUrlFactory;
    private final ConfigManagerProvider configManagerProvider;
    private final ApiClientFactory apiClientFactory;
    private final TokenStore tokenStore;

    public ConnectionChecker(JdbcUrlFactory jdbcUrlFactory, ConfigManagerProvider configManagerProvider, ApiClientFactory apiClientFactory, TokenStore tokenStore) {
        this.jdbcUrlFactory = jdbcUrlFactory;
        this.configManagerProvider = configManagerProvider;
        this.apiClientFactory = apiClientFactory;
        this.tokenStore = tokenStore;
    }

    public SessionInfo checkConnection(ConnectCallInput callInput, SslConfig sslConfig) throws ApiException {
        ApiClientSettingsBuilder settingsBuilder = ApiClientSettings.builder().basePath(callInput.url());
        ConnectionChecker.buildSslSettings(sslConfig, settingsBuilder);
        this.buildAuthSettings(callInput, settingsBuilder);
        return this.checkConnection(settingsBuilder.build());
    }

    public SessionInfo checkConnection(ConnectCallInput callInput) throws ApiException {
        ApiClientSettingsBuilder settingsBuilder = ApiClientSettings.builder().basePath(callInput.url());
        this.buildSslSettingsFromConfig(settingsBuilder);
        this.buildAuthSettings(callInput, settingsBuilder);
        return this.checkConnection(settingsBuilder.build());
    }

    private SessionInfo checkConnection(ApiClientSettings apiClientSettings) throws ApiException {
        ApiClient apiClient = this.apiClientFactory.buildClient(apiClientSettings);
        NodeInfo nodeInfo = new NodeManagementApi(apiClient).nodeInfo();
        String jdbcUrl = this.jdbcUrlFactory.constructJdbcUrl(apiClientSettings.basePath(), nodeInfo.getJdbcPort(), apiClientSettings.basicAuthenticationUsername(), apiClientSettings.basicAuthenticationPassword());
        return SessionInfo.builder().nodeUrl(apiClientSettings.basePath()).nodeName(nodeInfo.getName()).jdbcUrl(jdbcUrl).username(apiClientSettings.basicAuthenticationUsername()).build();
    }

    public SessionInfo checkConnectionWithoutAuthentication(ConnectCallInput callInput) throws ApiException {
        ApiClientSettingsBuilder settingsBuilder = ApiClientSettings.builder().basePath(callInput.url());
        this.buildSslSettingsFromConfig(settingsBuilder);
        return this.checkConnection(settingsBuilder.build());
    }

    private void buildAuthSettings(ConnectCallInput callInput, ApiClientSettingsBuilder settingsBuilder) {
        ConfigManager configManager = this.configManagerProvider.get();
        String username = ConnectionChecker.firstNonNullOrBlankString(callInput.username(), configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value()));
        String password = ConnectionChecker.firstNonNullOrBlankString(callInput.password(), configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD.value()));
        settingsBuilder.basicAuthenticationUsername(username);
        settingsBuilder.basicAuthenticationPassword(password);
        settingsBuilder.token(this.tokenStore.getCurrentToken());
    }

    @Nullable
    public static String firstNonNullOrBlankString(@Nullable String first, @Nullable String second) {
        if (!StringUtils.nullOrBlank((String)first)) {
            return first;
        }
        if (!StringUtils.nullOrBlank((String)second)) {
            return second;
        }
        return null;
    }

    private static void buildSslSettings(SslConfig sslConfig, ApiClientSettingsBuilder settingsBuilder) {
        settingsBuilder.keyStorePath(sslConfig.keyStorePath()).keyStorePassword(sslConfig.keyStorePassword()).trustStorePath(sslConfig.trustStorePath()).trustStorePassword(sslConfig.trustStorePassword());
    }

    private void buildSslSettingsFromConfig(ApiClientSettingsBuilder settingsBuilder) {
        ConfigManager configManager = this.configManagerProvider.get();
        settingsBuilder.keyStorePath(configManager.getCurrentProperty(CliConfigKeys.REST_KEY_STORE_PATH.value())).keyStorePassword(configManager.getCurrentProperty(CliConfigKeys.REST_KEY_STORE_PASSWORD.value())).trustStorePath(configManager.getCurrentProperty(CliConfigKeys.REST_TRUST_STORE_PATH.value())).trustStorePassword(configManager.getCurrentProperty(CliConfigKeys.REST_TRUST_STORE_PASSWORD.value())).ciphers(configManager.getCurrentProperty(CliConfigKeys.REST_CIPHERS.value()));
    }

    public void saveSettings(ConnectCallInput callInput, SslConfig sslConfig) {
        ConfigManager manager = this.configManagerProvider.get();
        if (sslConfig != null) {
            manager.setProperty(CliConfigKeys.REST_TRUST_STORE_PATH.value(), sslConfig.trustStorePath());
            manager.setProperty(CliConfigKeys.REST_TRUST_STORE_PASSWORD.value(), sslConfig.trustStorePassword());
            if (!StringUtils.nullOrBlank((String)sslConfig.keyStorePath())) {
                manager.setProperty(CliConfigKeys.REST_KEY_STORE_PATH.value(), sslConfig.keyStorePath());
                manager.setProperty(CliConfigKeys.REST_KEY_STORE_PASSWORD.value(), sslConfig.keyStorePassword());
            }
        }
    }
}

