/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.dcr.ReplicationNameCallInput;
import org.gridgain.internal.cli.call.dcr.ReplicationStatusCall;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import org.gridgain.internal.cli.decorators.ReplicationInfoDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Status data center replication."})
public class DcReplicationStatusReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ReplicationStatusCall replicationStatusCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.replicationStatusCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot show replication status")).print(new ReplicationInfoDecorator(this.plain)));
    }

    private ReplicationNameCallInput input(String url) {
        return ReplicationNameCallInput.builder().replicationName(this.name.replicationName()).clusterUrl(url).build();
    }
}

