/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.dcr.StartReplicationCall;
import org.gridgain.internal.cli.call.dcr.StartStopReplicationCallInput;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import org.gridgain.internal.cli.commands.dcr.DcReplicationTableArgsGroup;
import org.gridgain.internal.cli.decorators.ReplicationInfoDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start data center replication."})
public class DcReplicationStartCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @CommandLine.Option(names={"--schema"}, description={"Schema name. For example, PUBLIC."})
    private String schema;
    @CommandLine.ArgGroup(multiplicity="1")
    DcReplicationTableArgsGroup tableArgs;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private StartReplicationCall startReplicationCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.startReplicationCall).inputProvider(() -> StartStopReplicationCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).replicationName(this.name.replicationName()).allTables(this.tableArgs.all()).tables(this.tableArgs.tableNames()).schema(this.schema).build()).decorator(new ReplicationInfoDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot start replication")));
    }
}

