/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.pitr;

import jakarta.inject.Singleton;
import java.time.ZoneOffset;
import java.util.UUID;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.RecoveryApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.TablesRecoveryRequest;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStartCallInput;

@Singleton
public class TablesRecoveryStartCall
implements Call<TablesRecoveryStartCallInput, String> {
    private final ApiClientFactory clientFactory;

    public TablesRecoveryStartCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(TablesRecoveryStartCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        TablesRecoveryRequest recoveryRequest = new TablesRecoveryRequest().tables(input.tableNames()).timestamp(input.timestamp().atOffset(ZoneOffset.UTC));
        try {
            UUID operationId = client.recoverTables(recoveryRequest).getOperationId();
            return DefaultCallOutput.success("Point-in-time recovery has been started with ID " + operationId);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

