/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.sink;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.CdcManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.Sink;
import org.gridgain.internal.cli.call.cdc.sink.SinkCallInput;
import org.gridgain.internal.cli.core.exception.AlreadyExistsException;

@Singleton
public class CreateSinkCall
implements Call<SinkCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public CreateSinkCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(SinkCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).createSink(new Sink().type(input.type()).name(input.name()).parameters(input.params()));
            return DefaultCallOutput.success("Sink " + input.name() + " created.");
        }
        catch (IllegalArgumentException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
        catch (ApiException e) {
            if (ClusterNotInitializedExceptionHandler.isClusterNotInitialized(e)) {
                return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
            }
            if (e.getCode() == 409) {
                return DefaultCallOutput.failure(new AlreadyExistsException(e));
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

