/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum SourceType {
    GRIDGAIN("GRIDGAIN");

    private String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceType fromValue(String value) {
        for (SourceType b : SourceType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        SourceType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<SourceType> {
        public void write(JsonWriter jsonWriter, SourceType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public SourceType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return SourceType.fromValue(value);
        }
    }
}

