/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum SnapshotType {
    NOT_SPECIFIED("NOT_SPECIFIED"),
    FULL("FULL"),
    INCREMENTAL("INCREMENTAL");

    private String value;

    private SnapshotType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnapshotType fromValue(String value) {
        for (SnapshotType b : SnapshotType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        SnapshotType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<SnapshotType> {
        public void write(JsonWriter jsonWriter, SnapshotType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public SnapshotType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return SnapshotType.fromValue(value);
        }
    }
}

