/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.questions;

import io.micronaut.http.HttpStatus;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.apache.ignite.internal.cli.call.connect.AuthConfig;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.call.connect.ConnectWizardCall;
import org.apache.ignite.internal.cli.call.connect.ConnectionChecker;
import org.apache.ignite.internal.cli.call.connect.SslConfig;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.config.StateConfigProvider;
import org.apache.ignite.internal.cli.core.flow.Flow;
import org.apache.ignite.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAskerFactory;
import org.apache.ignite.internal.cli.core.repl.Session;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.rest.TokenStore;
import org.apache.ignite.internal.cli.core.style.component.QuestionUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import org.apache.ignite.internal.cli.core.style.element.UiElements;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ConnectToClusterQuestion {
    @Inject
    private ConnectWizardCall connectCall;
    @Inject
    private ConfigManagerProvider configManagerProvider;
    @Inject
    private StateConfigProvider stateConfigProvider;
    @Inject
    private Session session;
    @Inject
    private ConnectionChecker connectionChecker;

    public FlowBuilder<Void, String> askQuestionIfNotConnected(String clusterUrl) {
        String url = this.clusterUrlOrSessionNode(clusterUrl);
        if (url != null) {
            return Flows.from(url);
        }
        String defaultUrl = this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.CLUSTER_URL.value());
        QuestionUiComponent questionUiComponent = QuestionUiComponent.fromYesNoQuestion("You are not connected to node. Do you want to connect to the default node %s?", UiElements.url(defaultUrl));
        return Flows.acceptQuestion(questionUiComponent, () -> ConnectCallInput.builder().url(defaultUrl).checkClusterInit(false).build()).then(Flows.fromCall(this.connectCall)).print().map(ignored -> this.sessionNodeUrl());
    }

    @Nullable
    private String clusterUrlOrSessionNode(String clusterUrl) {
        return clusterUrl != null ? clusterUrl : this.sessionNodeUrl();
    }

    @Nullable
    private String sessionNodeUrl() {
        return this.session.info() != null ? this.session.info().nodeUrl() : null;
    }

    public FlowBuilder<Void, ConnectCallInput> askQuestionIfConnected(ConnectCallInput input) {
        SessionInfo sessionInfo = this.session.info();
        if (sessionInfo != null) {
            if (!Objects.equals(sessionInfo.nodeUrl(), input.url())) {
                return Flows.acceptQuestion(QuestionUiComponent.fromYesNoQuestion("You are already connected to the %s, do you want to connect to the %s?", UiElements.url(sessionInfo.nodeUrl()), UiElements.url(input.url())), () -> input);
            }
            String oldUsername = sessionInfo.username();
            String newUsername = ConnectionChecker.firstNonNullOrBlankString(input.username(), this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value()));
            if (newUsername != null && this.isClusterWithAuthentication(input)) {
                if (oldUsername == null) {
                    return Flows.acceptQuestion(QuestionUiComponent.fromYesNoQuestion("You are already connected to the %s, do you want to connect as %s?", UiElements.url(sessionInfo.nodeUrl()), UiElements.username(newUsername)), () -> input);
                }
                if (!oldUsername.equals(newUsername)) {
                    return Flows.acceptQuestion(QuestionUiComponent.fromYesNoQuestion("You are already connected to the %s as %s, do you want to connect as %s?", UiElements.url(sessionInfo.nodeUrl()), UiElements.username(oldUsername), UiElements.username(newUsername)), () -> input);
                }
            }
        }
        return Flows.from(input);
    }

    private boolean isClusterWithAuthentication(ConnectCallInput connectCallInput) {
        try {
            this.connectionChecker.checkConnectionWithoutAuthentication(connectCallInput);
            return false;
        }
        catch (ApiException e) {
            return e.getCause() == null && e.getCode() == HttpStatus.UNAUTHORIZED.getCode();
        }
    }

    public static void askQuestionToStoreCredentials(ConfigManager configManager, TokenStore tokenStore, @Nullable String username, @Nullable String password) {
        if (!StringUtils.nullOrBlank((String)username) && !StringUtils.nullOrBlank((String)password)) {
            String storedUsername = configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value());
            String storedPassword = configManager.getCurrentProperty(CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD.value());
            if (!username.equals(storedUsername) || !password.equals(storedPassword)) {
                QuestionUiComponent question = QuestionUiComponent.fromYesNoQuestion("Remember current credentials?", new UiElement[0]);
                Flows.acceptQuestion(question, () -> {
                    configManager.setProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value(), username);
                    configManager.setProperty(CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD.value(), password);
                    return "Config saved";
                }).print().start();
            }
        }
    }

    public void askQuestionOnReplStart() {
        String clusterUrl;
        QuestionUiComponent question;
        if (this.session.info() != null) {
            return;
        }
        String defaultUrl = this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.CLUSTER_URL.value());
        String lastConnectedUrl = this.stateConfigProvider.get().getProperty(CliConfigKeys.LAST_CONNECTED_URL.value());
        if (lastConnectedUrl != null) {
            question = QuestionUiComponent.fromYesNoQuestion("Do you want to reconnect to the last connected node %s?", UiElements.url(lastConnectedUrl));
            clusterUrl = lastConnectedUrl;
        } else if (defaultUrl != null) {
            question = QuestionUiComponent.fromYesNoQuestion("You appear to have not connected to any node yet. Do you want to connect to the default node %s?", UiElements.url(defaultUrl));
            clusterUrl = defaultUrl;
        } else {
            return;
        }
        Flows.acceptQuestion(question, () -> ConnectCallInput.builder().url(clusterUrl).checkClusterInit(true).build()).then(Flows.fromCall(this.connectCall)).print().ifThen(s -> !Objects.equals(clusterUrl, defaultUrl) && this.session.info() != null, this.defaultUrlQuestion(clusterUrl).print().build()).start();
    }

    private FlowBuilder<String, String> defaultUrlQuestion(String lastConnectedUrl) {
        return Flows.acceptQuestion(QuestionUiComponent.fromYesNoQuestion("Would you like to use %s as the default URL?", UiElements.url(lastConnectedUrl)), () -> {
            this.configManagerProvider.get().setProperty(CliConfigKeys.CLUSTER_URL.value(), lastConnectedUrl);
            return "Config saved";
        });
    }

    public static Flow<Void, SslConfig> askQuestionOnSslError() {
        QuestionUiComponent question = QuestionUiComponent.fromYesNoQuestion("SSL error occurred while connecting to the node, it could be due to the wrong trust store/key store configuration. Do you want to configure them now?", new UiElement[0]);
        QuestionUiComponent question2 = QuestionUiComponent.fromYesNoQuestion("Do you want to configure key store?", new UiElement[0]);
        return Flows.acceptQuestion(question, () -> {
            SslConfig config = new SslConfig();
            config.trustStorePath(ConnectToClusterQuestion.escapeWindowsPath(ConnectToClusterQuestion.enterFilePath("trust store path")));
            config.trustStorePassword(ConnectToClusterQuestion.enterPassword("trust store password"));
            return config;
        }).then(Flows.acceptQuestionFlow(question2, config -> {
            config.keyStorePath(ConnectToClusterQuestion.escapeWindowsPath(ConnectToClusterQuestion.enterFilePath("key store path")));
            config.keyStorePassword(ConnectToClusterQuestion.enterPassword("key store password"));
        })).build();
    }

    public static Flow<Void, AuthConfig> askQuestionOnAuthError() {
        QuestionUiComponent question = QuestionUiComponent.fromYesNoQuestion("Authentication error occurred while connecting to the node, it could be due to the wrong basic auth configuration. Do you want to configure them now?", new UiElement[0]);
        return Flows.acceptQuestion(question, () -> {
            AuthConfig authConfig = new AuthConfig();
            authConfig.username(ConnectToClusterQuestion.enterString("username"));
            authConfig.password(ConnectToClusterQuestion.enterPassword("user password"));
            return authConfig;
        }).build();
    }

    private static String enterString(String question) {
        return QuestionAskerFactory.newQuestionAsker().askQuestion("Enter " + question + ": ");
    }

    private static String enterFilePath(String question) {
        return QuestionAskerFactory.newQuestionAsker().completeFilePaths(true).askQuestion("Enter " + question + ": ");
    }

    private static String enterPassword(String question) {
        return QuestionAskerFactory.newQuestionAsker().maskInput(true).askQuestion("Enter " + question + ": ");
    }

    private static String escapeWindowsPath(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            sb.append(c);
            if (c != '\\') continue;
            if (i == string.length() - 1 || string.charAt(i + 1) != '\\') {
                sb.append('\\');
                continue;
            }
            ++i;
        }
        return sb.toString();
    }
}

