/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.management.zone;

import jakarta.inject.Singleton;
import java.util.Collections;
import org.apache.ignite.internal.cli.call.management.zone.ResetDataNodesCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElements;
import org.apache.ignite.rest.client.api.DataNodesApi;
import org.apache.ignite.rest.client.invoker.ApiException;

@Singleton
public class ResetDataNodesCall
implements Call<ResetDataNodesCallInput, String> {
    private final ApiClientFactory clientFactory;

    ResetDataNodesCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<String> execute(ResetDataNodesCallInput input) {
        try {
            DataNodesApi api = new DataNodesApi(this.clientFactory.getClient(input.clusterUrl()));
            api.resetDataNodesForZones(input.zoneNames() == null ? Collections.emptyList() : input.zoneNames());
            return DefaultCallOutput.success(MessageUiComponent.from(UiElements.done()).render());
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

