/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.core.repl.registry.impl;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.repl.registry.impl.RegistryImplBase;
import org.apache.ignite.rest.client.model.ReplicationInfo;
import org.gridgain.internal.cli.call.dcr.ListReplicationCall;
import org.gridgain.internal.cli.call.dcr.ListReplicationCallInput;
import org.gridgain.internal.cli.core.repl.registry.ReplicationsRegistry;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ReplicationsRegistryImpl
extends RegistryImplBase<List<String>>
implements ReplicationsRegistry {
    private final ListReplicationCall call;

    public ReplicationsRegistryImpl(ListReplicationCall call) {
        this.call = call;
    }

    @Override
    @Nullable
    protected List<String> doGetState(String url) {
        ListReplicationCallInput input = ListReplicationCallInput.builder().clusterUrl(url).build();
        CallOutput<List<ReplicationInfo>> output = this.call.execute(input);
        if (output.hasError() || output.isEmpty()) {
            return null;
        }
        return output.body().stream().map(ReplicationInfo::getName).collect(Collectors.toList());
    }

    @Override
    public List<String> replicationNames() {
        List<String> names = (List<String>)this.getResult();
        return names != null ? names : List.of();
    }
}

