/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.role.ListRolesCall;
import org.gridgain.internal.cli.call.rbac.role.ListRolesCallInput;
import org.gridgain.internal.cli.decorators.RoleListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List roles"})
public class RoleListCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--user"}, description={"Filter by user name"})
    private String user;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ListRolesCall listRolesCall;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.listRolesCall).inputProvider(() -> ListRolesCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).filterByUsername(this.user).build()).decorator(new RoleListDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot list roles")));
    }
}

