/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.pitr.tables;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCall;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCallInput;
import org.gridgain.internal.cli.commands.pitr.tables.OperationIdArgGroup;
import org.gridgain.internal.cli.decorators.RecoveryStateDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="state", description={"View state of a table point-in-time recovery"})
class RecoveryTablesStateCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private OperationIdArgGroup operationIdArgGroup;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private TablesRecoveryStateCall call;

    RecoveryTablesStateCommand() {
    }

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.call).inputProvider(this::buildCallInput).decorator(new RecoveryStateDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot view recovery state")));
    }

    private TablesRecoveryStateCallInput buildCallInput() {
        return TablesRecoveryStateCallInput.builder().operationId(this.operationIdArgGroup.operationId()).clusterUrl(this.clusterUrl.getClusterUrl()).build();
    }
}

