/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.replication.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.cdc.replication.ListReplicationsCall;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"CDC replication list command."})
public class CdcReplicationListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private ListReplicationsCall listReplicationsCall;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.listReplicationsCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list replication")).print());
    }
}

