/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.role;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gridgain.internal.cli.call.rbac.privilege.Privilege;

public class Role {
    private final String roleName;
    private final List<String> assignedUsers;
    private final List<Privilege> privileges;

    private Role(String roleName, List<String> assignedUsers, List<Privilege> privileges) {
        this.roleName = roleName;
        this.assignedUsers = assignedUsers;
        this.privileges = privileges;
    }

    public static RoleBuilder builder() {
        return new RoleBuilder();
    }

    public static RoleBuilder builderFrom(Role role) {
        return new RoleBuilder().roleName(role.roleName()).assignedUsers(role.assignedUsers()).privileges(role.privileges());
    }

    public String roleName() {
        return this.roleName;
    }

    public List<String> assignedUsers() {
        return this.assignedUsers;
    }

    public List<Privilege> privileges() {
        return this.privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.roleName, role.roleName) && Objects.equals(this.assignedUsers, role.assignedUsers) && Objects.equals(this.privileges, role.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.roleName, this.assignedUsers, this.privileges);
    }

    public String toString() {
        return "Role{roleName='" + this.roleName + "', assignedUsers=" + this.assignedUsers + ", privileges=" + this.privileges + "}";
    }

    public static class RoleBuilder {
        private String roleName;
        private List<String> assignedUsers = new ArrayList<String>();
        private List<Privilege> privileges = new ArrayList<Privilege>();

        public RoleBuilder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public String roleName() {
            return this.roleName;
        }

        public RoleBuilder assignedUsers(List<String> assignedUsers) {
            this.assignedUsers = assignedUsers;
            return this;
        }

        public RoleBuilder privileges(List<Privilege> privileges) {
            this.privileges = privileges;
            return this;
        }

        public Role build() {
            return new Role(this.roleName, this.assignedUsers, this.privileges);
        }
    }
}

