/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.ignite.internal.cli.core.flow.Flowable;

public class DefaultFlowable<T>
implements Flowable<T> {
    private final T body;
    private final Throwable cause;

    private DefaultFlowable(T body, Throwable cause) {
        this.body = body;
        this.cause = cause;
    }

    @Override
    public Throwable errorCause() {
        return this.cause;
    }

    @Override
    public T value() {
        return this.body;
    }

    @Override
    public Class<T> type() {
        return this.body.getClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFlowable that = (DefaultFlowable)o;
        return Objects.equals(this.body, that.body) && Objects.equals(this.cause, that.cause);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.cause);
    }

    public String toString() {
        return new StringJoiner(", ", DefaultFlowable.class.getSimpleName() + "[", "]").add("body=" + this.body).add("cause=" + this.cause).toString();
    }

    public static <T> DefaultFlowOutputBuilder<T> builder() {
        return new DefaultFlowOutputBuilder();
    }

    public static class DefaultFlowOutputBuilder<T> {
        private T body;
        private Throwable cause;

        public DefaultFlowOutputBuilder<T> body(T body) {
            this.body = body;
            return this;
        }

        public DefaultFlowOutputBuilder<T> cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DefaultFlowable<T> build() {
            return new DefaultFlowable<T>(this.body, this.cause);
        }
    }
}

