/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli;

import io.micronaut.configuration.picocli.MicronautFactory;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.ReplManager;
import org.apache.ignite.internal.cli.VersionProvider;
import org.apache.ignite.internal.cli.commands.TopLevelCliCommand;
import org.apache.ignite.internal.cli.config.ConfigDefaultValueProvider;
import org.apache.ignite.internal.cli.config.StateFolderProvider;
import org.apache.ignite.internal.cli.core.exception.handler.PicocliExecutionExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.question.JlineQuestionWriterReaderFactory;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAskerFactory;
import org.apache.ignite.internal.cli.core.repl.executor.ReplExecutorProviderImpl;
import org.fusesource.jansi.AnsiConsole;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

public class Main {
    private static final String[] BANNER = new String[]{"", "  _________        _____ __________________        _____", "  __  ____/___________(_)______  /__  ____/______ ____(_)_______", "  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \\", "  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /", "  \\____/   /_/     /_/   \\_,__/   \\____/   \\__,_/  /_/   /_/ /_/"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Main.initJavaLoggerProps();
        int exitCode = 0;
        ApplicationContextBuilder builder = ApplicationContext.builder((String[])new String[]{"cli"}).deduceEnvironment(Boolean.valueOf(false));
        try (MicronautFactory micronautFactory = new MicronautFactory(builder.start());){
            AnsiConsole.systemInstall();
            Main.initReplExecutor(micronautFactory);
            Main.initQuestionAsker(micronautFactory);
            if (args.length != 0 || !Main.isatty()) {
                try {
                    exitCode = Main.executeCommand(args, micronautFactory);
                }
                catch (Exception e) {
                    System.err.println("Error occurred during command execution");
                }
            } else {
                Main.enterRepl(micronautFactory);
            }
        }
        catch (Exception e) {
            System.err.println("Error occurred during initialization");
        }
        finally {
            AnsiConsole.systemUninstall();
        }
        System.exit(exitCode);
    }

    private static boolean isatty() {
        return System.console() != null;
    }

    private static void initReplExecutor(MicronautFactory micronautFactory) throws Exception {
        ReplExecutorProviderImpl replExecutorProvider = (ReplExecutorProviderImpl)micronautFactory.create(ReplExecutorProviderImpl.class);
        replExecutorProvider.injectFactory(micronautFactory);
    }

    private static void initQuestionAsker(MicronautFactory micronautFactory) throws Exception {
        Terminal terminal = (Terminal)micronautFactory.create(Terminal.class);
        QuestionAskerFactory.setWriterReaderFactory(new JlineQuestionWriterReaderFactory(terminal));
    }

    private static void enterRepl(MicronautFactory micronautFactory) throws Exception {
        VersionProvider versionProvider = (VersionProvider)micronautFactory.create(VersionProvider.class);
        System.out.println(Main.banner(versionProvider));
        ReplManager replManager = (ReplManager)micronautFactory.create(ReplManager.class);
        replManager.subscribe();
        replManager.startReplMode();
    }

    private static int executeCommand(String[] args, MicronautFactory micronautFactory) throws Exception {
        CommandLine cmd = new CommandLine(TopLevelCliCommand.class, (CommandLine.IFactory)micronautFactory);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PicocliExecutionExceptionHandler());
        cmd.setDefaultValueProvider((CommandLine.IDefaultValueProvider)micronautFactory.create(ConfigDefaultValueProvider.class));
        cmd.setTrimQuotes(true);
        cmd.setCaseInsensitiveEnumValuesAllowed(true);
        return cmd.execute(args);
    }

    private static String banner(VersionProvider versionProvider) {
        String banner = Arrays.stream(BANNER).map(arg_0 -> ((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO).string(arg_0)).collect(Collectors.joining("\n"));
        return "\n" + banner + "\n" + " ".repeat(22) + versionProvider.getVersion()[0] + "\n\n";
    }

    private static void initJavaLoggerProps() {
        try (InputStream propsFile = Main.class.getResourceAsStream("/cli.java.util.logging.properties");){
            if (propsFile != null) {
                LogManager.getLogManager().updateConfiguration(propsFile, configurationKey -> {
                    if (configurationKey.equals("java.util.logging.FileHandler.pattern")) {
                        return (oldConfigValue, newConfigValue) -> {
                            if (newConfigValue == null) {
                                return oldConfigValue;
                            }
                            try {
                                return Main.getLogsDir() + "/" + newConfigValue;
                            }
                            catch (IOException e) {
                                return newConfigValue;
                            }
                        };
                    }
                    return (o, n) -> n == null ? o : n;
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getLogsDir() throws IOException {
        String envLogsDir = System.getenv("IGNITE_CLI_LOGS_DIR");
        String logsDir = envLogsDir != null ? envLogsDir : StateFolderProvider.getStateFile("logs").getAbsolutePath();
        File logsDirFile = new File(logsDir);
        if (!logsDirFile.exists() && !logsDirFile.mkdirs()) {
            throw new IOException("Failed to create directory " + logsDir);
        }
        if (logsDirFile.isDirectory()) {
            return logsDir;
        }
        throw new IOException(logsDir + " is not a directory");
    }
}

