/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.ignite.rest.client.invoker.JSON;
import org.apache.ignite.rest.client.model.Privilege;
import org.apache.ignite.rest.client.model.User;

public class RoleView {
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    @Nonnull
    private String role;
    public static final String SERIALIZED_NAME_USERS = "users";
    @SerializedName(value="users")
    @Nullable
    private List<User> users = new ArrayList<User>();
    public static final String SERIALIZED_NAME_PRIVILEGES = "privileges";
    @SerializedName(value="privileges")
    @Nullable
    private List<Privilege> privileges = new ArrayList<Privilege>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RoleView role(@Nonnull String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nonnull String role) {
        this.role = role;
    }

    public RoleView users(@Nullable List<User> users) {
        this.users = users;
        return this;
    }

    public RoleView addUsersItem(User usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<User>();
        }
        this.users.add(usersItem);
        return this;
    }

    @Nullable
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(@Nullable List<User> users) {
        this.users = users;
    }

    public RoleView privileges(@Nullable List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public RoleView addPrivilegesItem(Privilege privilegesItem) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<Privilege>();
        }
        this.privileges.add(privilegesItem);
        return this;
    }

    @Nullable
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(@Nullable List<Privilege> privileges) {
        this.privileges = privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleView roleView = (RoleView)o;
        return Objects.equals(this.role, roleView.role) && Objects.equals(this.users, roleView.users) && Objects.equals(this.privileges, roleView.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.users, this.privileges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleView {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    privileges: ").append(this.toIndentedString(this.privileges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayprivileges;
        int i;
        JsonArray jsonArrayusers;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in RoleView is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RoleView` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERS) != null && !jsonObj.get(SERIALIZED_NAME_USERS).isJsonNull() && (jsonArrayusers = jsonObj.getAsJsonArray(SERIALIZED_NAME_USERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_USERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `users` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERS).toString()));
            }
            for (i = 0; i < jsonArrayusers.size(); ++i) {
                User.validateJsonElement(jsonArrayusers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIVILEGES) != null && !jsonObj.get(SERIALIZED_NAME_PRIVILEGES).isJsonNull() && (jsonArrayprivileges = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRIVILEGES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRIVILEGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `privileges` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIVILEGES).toString()));
            }
            for (i = 0; i < jsonArrayprivileges.size(); ++i) {
                Privilege.validateJsonElement(jsonArrayprivileges.get(i));
            }
        }
    }

    public static RoleView fromJson(String jsonString) throws IOException {
        return (RoleView)JSON.getGson().fromJson(jsonString, RoleView.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_USERS);
        openapiFields.add(SERIALIZED_NAME_PRIVILEGES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ROLE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RoleView.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RoleView.class));
            return new TypeAdapter<RoleView>(){

                public void write(JsonWriter out, RoleView value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RoleView read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    RoleView.validateJsonElement(jsonElement);
                    return (RoleView)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

