/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.pitr.tables;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCall;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCallInput;
import org.gridgain.internal.cli.commands.pitr.tables.OperationIdArgGroup;
import org.gridgain.internal.cli.decorators.RecoveryStateDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="state", description={"View state of a table point-in-time recovery"})
class RecoveryTablesStateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private OperationIdArgGroup operationIdArgGroup;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private TablesRecoveryStateCall call;
    @Inject
    private ConnectToClusterQuestion question;

    RecoveryTablesStateReplCommand() {
    }

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot view recovery state")).print(new RecoveryStateDecorator(this.plain)));
    }

    private TablesRecoveryStateCallInput buildCallInput(String clusterUrl) {
        return TablesRecoveryStateCallInput.builder().operationId(this.operationIdArgGroup.operationId()).clusterUrl(clusterUrl).build();
    }
}

