/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.rest.client.model.CreateReplicationRequestAuthConfig;
import org.apache.ignite.rest.client.model.CreateReplicationRequestSslConfig;
import org.gridgain.internal.cli.call.dcr.CreateReplicationCall;
import org.gridgain.internal.cli.call.dcr.CreateReplicationCallInput;
import org.gridgain.internal.cli.commands.dcr.DcReplicationAuthConfigGroup;
import org.gridgain.internal.cli.commands.dcr.DcrReplicationSslConfigGroup;
import org.gridgain.internal.cli.decorators.ReplicationInfoDecorator;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create data center replication."})
public class DcReplicationCreateCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @CommandLine.Option(names={"--name"}, description={"The unique name of the replication. Should be without whitespaces."}, required=true)
    private String name;
    @CommandLine.Option(names={"--source-cluster-address"}, description={"Comma-separated list of client addresses of the cluster that is a source cluster for the replication. Example: localhost:10800,localhost:10801"}, required=true, split=",")
    private List<String> sourceClusterAddresses;
    @CommandLine.ArgGroup(exclusive=false)
    @Nullable
    private DcReplicationAuthConfigGroup authConfig;
    @CommandLine.ArgGroup(exclusive=false)
    @Nullable
    private DcrReplicationSslConfigGroup sslConfig;
    @CommandLine.Option(names={"--replication-nodes"}, description={"Comma-separated replication nodes names, worker node will be chosen from the list of replication nodes."}, split=",")
    private List<String> replicationNodes;
    @Inject
    private CreateReplicationCall createReplicationCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.createReplicationCall).inputProvider(() -> CreateReplicationCallInput.builder().name(this.name).clusterUrl(this.clusterUrl.getClusterUrl()).sourceClusterAddresses(this.sourceClusterAddresses).authConfig(DcReplicationCreateCommand.toRequestAuthConfig(this.authConfig)).sslConfig(DcReplicationCreateCommand.toRequestSslConfig(this.sslConfig)).replicationNodes(this.replicationNodes).build()).decorator(new ReplicationInfoDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot create replication")));
    }

    @Nullable
    private static CreateReplicationRequestAuthConfig toRequestAuthConfig(@Nullable DcReplicationAuthConfigGroup authConfig) {
        if (authConfig == null) {
            return null;
        }
        return new CreateReplicationRequestAuthConfig().username(authConfig.username()).password(authConfig.password());
    }

    @Nullable
    private static CreateReplicationRequestSslConfig toRequestSslConfig(@Nullable DcrReplicationSslConfigGroup sslConfig) {
        if (sslConfig == null) {
            return null;
        }
        return new CreateReplicationRequestSslConfig().keyStorePath(sslConfig.keyStorePath()).keyStorePassword(sslConfig.keyStorePassword()).trustStorePath(sslConfig.trustStorePath()).trustStorePassword(sslConfig.trustStorePassword());
    }
}

